// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a user in the user pool.
 */
public class User private constructor(builder: Builder) {
    /**
     * The ARN of the user.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The authentication type for the user.
     */
    public val authenticationType: aws.sdk.kotlin.services.appstream.model.AuthenticationType? = builder.authenticationType
    /**
     * The date and time the user was created in the user pool.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * Specifies whether the user in the user pool is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The first name, or given name, of the user.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * The last name, or surname, of the user.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The status of the user in the user pool. The status can be one of the following:
     * + UNCONFIRMED – The user is created but not confirmed.
     * + CONFIRMED – The user is confirmed.
     * + ARCHIVED – The user is no longer active.
     * + COMPROMISED – The user is disabled because of a potential security threat.
     * + UNKNOWN – The user status is not known.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The email address of the user.
     *
     * Users' email addresses are case-sensitive.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("arn=$arn,")
        append("authenticationType=$authenticationType,")
        append("createdTime=$createdTime,")
        append("enabled=$enabled,")
        append("firstName=*** Sensitive Data Redacted ***,")
        append("lastName=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("userName=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (arn != other.arn) return false
        if (authenticationType != other.authenticationType) return false
        if (createdTime != other.createdTime) return false
        if (enabled != other.enabled) return false
        if (firstName != other.firstName) return false
        if (lastName != other.lastName) return false
        if (status != other.status) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.User = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the user.
         */
        public var arn: kotlin.String? = null
        /**
         * The authentication type for the user.
         */
        public var authenticationType: aws.sdk.kotlin.services.appstream.model.AuthenticationType? = null
        /**
         * The date and time the user was created in the user pool.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the user in the user pool is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The first name, or given name, of the user.
         */
        public var firstName: kotlin.String? = null
        /**
         * The last name, or surname, of the user.
         */
        public var lastName: kotlin.String? = null
        /**
         * The status of the user in the user pool. The status can be one of the following:
         * + UNCONFIRMED – The user is created but not confirmed.
         * + CONFIRMED – The user is confirmed.
         * + ARCHIVED – The user is no longer active.
         * + COMPROMISED – The user is disabled because of a potential security threat.
         * + UNKNOWN – The user status is not known.
         */
        public var status: kotlin.String? = null
        /**
         * The email address of the user.
         *
         * Users' email addresses are case-sensitive.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.User) : this() {
            this.arn = x.arn
            this.authenticationType = x.authenticationType
            this.createdTime = x.createdTime
            this.enabled = x.enabled
            this.firstName = x.firstName
            this.lastName = x.lastName
            this.status = x.status
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.User = User(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
