// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppBlockRequest private constructor(builder: Builder) {
    /**
     * The description of the app block.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name of the app block. This is not displayed to the user.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the app block.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The packaging type of the app block.
     */
    public val packagingType: aws.sdk.kotlin.services.appstream.model.PackagingType? = builder.packagingType
    /**
     * The post setup script details of the app block. This can only be provided for the `APPSTREAM2` PackagingType.
     */
    public val postSetupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = builder.postSetupScriptDetails
    /**
     * The setup script details of the app block. This must be provided for the `CUSTOM` PackagingType.
     */
    public val setupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = builder.setupScriptDetails
    /**
     * The source S3 location of the app block.
     */
    public val sourceS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = builder.sourceS3Location
    /**
     * The tags assigned to the app block.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppBlockRequest(")
        append("description=$description,")
        append("displayName=$displayName,")
        append("name=$name,")
        append("packagingType=$packagingType,")
        append("postSetupScriptDetails=$postSetupScriptDetails,")
        append("setupScriptDetails=$setupScriptDetails,")
        append("sourceS3Location=$sourceS3Location,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (packagingType?.hashCode() ?: 0)
        result = 31 * result + (postSetupScriptDetails?.hashCode() ?: 0)
        result = 31 * result + (setupScriptDetails?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Location?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppBlockRequest

        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (name != other.name) return false
        if (packagingType != other.packagingType) return false
        if (postSetupScriptDetails != other.postSetupScriptDetails) return false
        if (setupScriptDetails != other.setupScriptDetails) return false
        if (sourceS3Location != other.sourceS3Location) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the app block.
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the app block. This is not displayed to the user.
         */
        public var displayName: kotlin.String? = null
        /**
         * The name of the app block.
         */
        public var name: kotlin.String? = null
        /**
         * The packaging type of the app block.
         */
        public var packagingType: aws.sdk.kotlin.services.appstream.model.PackagingType? = null
        /**
         * The post setup script details of the app block. This can only be provided for the `APPSTREAM2` PackagingType.
         */
        public var postSetupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = null
        /**
         * The setup script details of the app block. This must be provided for the `CUSTOM` PackagingType.
         */
        public var setupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = null
        /**
         * The source S3 location of the app block.
         */
        public var sourceS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = null
        /**
         * The tags assigned to the app block.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest) : this() {
            this.description = x.description
            this.displayName = x.displayName
            this.name = x.name
            this.packagingType = x.packagingType
            this.postSetupScriptDetails = x.postSetupScriptDetails
            this.setupScriptDetails = x.setupScriptDetails
            this.sourceS3Location = x.sourceS3Location
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest = CreateAppBlockRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ScriptDetails] inside the given [block]
         */
        public fun postSetupScriptDetails(block: aws.sdk.kotlin.services.appstream.model.ScriptDetails.Builder.() -> kotlin.Unit) {
            this.postSetupScriptDetails = aws.sdk.kotlin.services.appstream.model.ScriptDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ScriptDetails] inside the given [block]
         */
        public fun setupScriptDetails(block: aws.sdk.kotlin.services.appstream.model.ScriptDetails.Builder.() -> kotlin.Unit) {
            this.setupScriptDetails = aws.sdk.kotlin.services.appstream.model.ScriptDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.S3Location] inside the given [block]
         */
        public fun sourceS3Location(block: aws.sdk.kotlin.services.appstream.model.S3Location.Builder.() -> kotlin.Unit) {
            this.sourceS3Location = aws.sdk.kotlin.services.appstream.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
