// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an app block builder.
 */
public class AppBlockBuilder private constructor(builder: Builder) {
    /**
     * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block builder only through the specified endpoints.
     */
    public val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The app block builder errors.
     */
    public val appBlockBuilderErrors: List<ResourceError>? = builder.appBlockBuilderErrors
    /**
     * The ARN of the app block builder.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The creation time of the app block builder.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the app block builder.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name of the app block builder.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Indicates whether default internet access is enabled for the app block builder.
     */
    public val enableDefaultInternetAccess: kotlin.Boolean? = builder.enableDefaultInternetAccess
    /**
     * The ARN of the IAM role that is applied to the app block builder.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The instance type of the app block builder.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The name of the app block builder.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform of the app block builder.
     *
     * `WINDOWS_SERVER_2019` is the only valid value.
     */
    public val platform: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderPlatformType? = builder.platform
    /**
     * The state of the app block builder.
     */
    public val state: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderState? = builder.state
    /**
     * The state change reason.
     */
    public val stateChangeReason: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderStateChangeReason? = builder.stateChangeReason
    /**
     * The VPC configuration for the app block builder.
     */
    public val vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.AppBlockBuilder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppBlockBuilder(")
        append("accessEndpoints=$accessEndpoints,")
        append("appBlockBuilderErrors=$appBlockBuilderErrors,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("enableDefaultInternetAccess=$enableDefaultInternetAccess,")
        append("iamRoleArn=$iamRoleArn,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("platform=$platform,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (appBlockBuilderErrors?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (enableDefaultInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppBlockBuilder

        if (accessEndpoints != other.accessEndpoints) return false
        if (appBlockBuilderErrors != other.appBlockBuilderErrors) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (enableDefaultInternetAccess != other.enableDefaultInternetAccess) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.AppBlockBuilder = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block builder only through the specified endpoints.
         */
        public var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The app block builder errors.
         */
        public var appBlockBuilderErrors: List<ResourceError>? = null
        /**
         * The ARN of the app block builder.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time of the app block builder.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the app block builder.
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the app block builder.
         */
        public var displayName: kotlin.String? = null
        /**
         * Indicates whether default internet access is enabled for the app block builder.
         */
        public var enableDefaultInternetAccess: kotlin.Boolean? = null
        /**
         * The ARN of the IAM role that is applied to the app block builder.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The instance type of the app block builder.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The name of the app block builder.
         */
        public var name: kotlin.String? = null
        /**
         * The platform of the app block builder.
         *
         * `WINDOWS_SERVER_2019` is the only valid value.
         */
        public var platform: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderPlatformType? = null
        /**
         * The state of the app block builder.
         */
        public var state: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderState? = null
        /**
         * The state change reason.
         */
        public var stateChangeReason: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderStateChangeReason? = null
        /**
         * The VPC configuration for the app block builder.
         */
        public var vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.AppBlockBuilder) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.appBlockBuilderErrors = x.appBlockBuilderErrors
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.displayName = x.displayName
            this.enableDefaultInternetAccess = x.enableDefaultInternetAccess
            this.iamRoleArn = x.iamRoleArn
            this.instanceType = x.instanceType
            this.name = x.name
            this.platform = x.platform
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.AppBlockBuilder = AppBlockBuilder(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.AppBlockBuilderStateChangeReason] inside the given [block]
         */
        public fun stateChangeReason(block: aws.sdk.kotlin.services.appstream.model.AppBlockBuilderStateChangeReason.Builder.() -> kotlin.Unit) {
            this.stateChangeReason = aws.sdk.kotlin.services.appstream.model.AppBlockBuilderStateChangeReason.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.appstream.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.appstream.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
