// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an action and whether the action is enabled or disabled for users during their streaming sessions.
 */
public class UserSetting private constructor(builder: Builder) {
    /**
     * The action that is enabled or disabled.
     */
    public val action: aws.sdk.kotlin.services.appstream.model.Action? = builder.action
    /**
     * Specifies the number of characters that can be copied by end users from the local device to the remote session, and to the local device from the remote session.
     *
     * This can be specified only for the `CLIPBOARD_COPY_FROM_LOCAL_DEVICE` and `CLIPBOARD_COPY_TO_LOCAL_DEVICE` actions.
     *
     * This defaults to 20,971,520 (20 MB) when unspecified and the permission is `ENABLED`. This can't be specified when the permission is `DISABLED`.
     *
     * This can only be specified for AlwaysOn and OnDemand fleets. The attribute is not supported on Elastic fleets.
     *
     * The value can be between 1 and 20,971,520 (20 MB).
     */
    public val maximumLength: kotlin.Int? = builder.maximumLength
    /**
     * Indicates whether the action is enabled or disabled.
     */
    public val permission: aws.sdk.kotlin.services.appstream.model.Permission? = builder.permission

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.UserSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserSetting(")
        append("action=$action,")
        append("maximumLength=$maximumLength,")
        append("permission=$permission")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (maximumLength ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserSetting

        if (action != other.action) return false
        if (maximumLength != other.maximumLength) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.UserSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action that is enabled or disabled.
         */
        public var action: aws.sdk.kotlin.services.appstream.model.Action? = null
        /**
         * Specifies the number of characters that can be copied by end users from the local device to the remote session, and to the local device from the remote session.
         *
         * This can be specified only for the `CLIPBOARD_COPY_FROM_LOCAL_DEVICE` and `CLIPBOARD_COPY_TO_LOCAL_DEVICE` actions.
         *
         * This defaults to 20,971,520 (20 MB) when unspecified and the permission is `ENABLED`. This can't be specified when the permission is `DISABLED`.
         *
         * This can only be specified for AlwaysOn and OnDemand fleets. The attribute is not supported on Elastic fleets.
         *
         * The value can be between 1 and 20,971,520 (20 MB).
         */
        public var maximumLength: kotlin.Int? = null
        /**
         * Indicates whether the action is enabled or disabled.
         */
        public var permission: aws.sdk.kotlin.services.appstream.model.Permission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.UserSetting) : this() {
            this.action = x.action
            this.maximumLength = x.maximumLength
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.UserSetting = UserSetting(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
