// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateFleetRequest private constructor(builder: Builder) {
    /**
     * The fleet attributes to delete.
     */
    public val attributesToDelete: List<FleetAttribute>? = builder.attributesToDelete
    /**
     * The desired capacity for the fleet. This is not allowed for Elastic fleets.
     */
    public val computeCapacity: aws.sdk.kotlin.services.appstream.model.ComputeCapacity? = builder.computeCapacity
    /**
     * Deletes the VPC association for the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val deleteVpcConfig: kotlin.Boolean? = builder.deleteVpcConfig
    /**
     * The description to display.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
     *
     * Specify a value between 60 and 360000.
     */
    public val disconnectTimeoutInSeconds: kotlin.Int? = builder.disconnectTimeoutInSeconds
    /**
     * The fleet name to display.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain.
     */
    public val domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = builder.domainJoinInfo
    /**
     * Enables or disables default internet access for the fleet.
     */
    public val enableDefaultInternetAccess: kotlin.Boolean? = builder.enableDefaultInternetAccess
    /**
     * The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
     *
     * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `DisconnectTimeoutInSeconds` time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in `DisconnectTimeoutInSeconds` elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
     *
     * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.
     *
     * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
     */
    public val idleDisconnectTimeoutInSeconds: kotlin.Int? = builder.idleDisconnectTimeoutInSeconds
    /**
     * The ARN of the public, private, or shared image to use.
     */
    public val imageArn: kotlin.String? = builder.imageArn
    /**
     * The name of the image used to create the fleet.
     */
    public val imageName: kotlin.String? = builder.imageName
    /**
     * The instance type to use when launching fleet instances. The following instance types are available:
     * + stream.standard.small
     * + stream.standard.medium
     * + stream.standard.large
     * + stream.standard.xlarge
     * + stream.standard.2xlarge
     * + stream.compute.large
     * + stream.compute.xlarge
     * + stream.compute.2xlarge
     * + stream.compute.4xlarge
     * + stream.compute.8xlarge
     * + stream.memory.large
     * + stream.memory.xlarge
     * + stream.memory.2xlarge
     * + stream.memory.4xlarge
     * + stream.memory.8xlarge
     * + stream.memory.z1d.large
     * + stream.memory.z1d.xlarge
     * + stream.memory.z1d.2xlarge
     * + stream.memory.z1d.3xlarge
     * + stream.memory.z1d.6xlarge
     * + stream.memory.z1d.12xlarge
     * + stream.graphics-design.large
     * + stream.graphics-design.xlarge
     * + stream.graphics-design.2xlarge
     * + stream.graphics-design.4xlarge
     * + stream.graphics-desktop.2xlarge
     * + stream.graphics.g4dn.xlarge
     * + stream.graphics.g4dn.2xlarge
     * + stream.graphics.g4dn.4xlarge
     * + stream.graphics.g4dn.8xlarge
     * + stream.graphics.g4dn.12xlarge
     * + stream.graphics.g4dn.16xlarge
     * + stream.graphics-pro.4xlarge
     * + stream.graphics-pro.8xlarge
     * + stream.graphics-pro.16xlarge
     *
     * The following instance types are available for Elastic fleets:
     * + stream.standard.small
     * + stream.standard.medium
     * + stream.standard.large
     * + stream.standard.xlarge
     * + stream.standard.2xlarge
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The maximum number of concurrent sessions for a fleet.
     */
    public val maxConcurrentSessions: kotlin.Int? = builder.maxConcurrentSessions
    /**
     * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
     */
    public val maxSessionsPerInstance: kotlin.Int? = builder.maxSessionsPerInstance
    /**
     * The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
     *
     * Specify a value between 600 and 432000.
     */
    public val maxUserDurationInSeconds: kotlin.Int? = builder.maxUserDurationInSeconds
    /**
     * A unique name for the fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     */
    public val platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = builder.platform
    /**
     * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
     */
    public val sessionScriptS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = builder.sessionScriptS3Location
    /**
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays.
     *
     * The default value is `APP`.
     */
    public val streamView: aws.sdk.kotlin.services.appstream.model.StreamView? = builder.streamView
    /**
     * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.
     */
    public val usbDeviceFilterStrings: List<String>? = builder.usbDeviceFilterStrings
    /**
     * The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.
     */
    public val vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.UpdateFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFleetRequest(")
        append("attributesToDelete=$attributesToDelete,")
        append("computeCapacity=$computeCapacity,")
        append("deleteVpcConfig=$deleteVpcConfig,")
        append("description=$description,")
        append("disconnectTimeoutInSeconds=$disconnectTimeoutInSeconds,")
        append("displayName=$displayName,")
        append("domainJoinInfo=$domainJoinInfo,")
        append("enableDefaultInternetAccess=$enableDefaultInternetAccess,")
        append("iamRoleArn=$iamRoleArn,")
        append("idleDisconnectTimeoutInSeconds=$idleDisconnectTimeoutInSeconds,")
        append("imageArn=$imageArn,")
        append("imageName=$imageName,")
        append("instanceType=$instanceType,")
        append("maxConcurrentSessions=$maxConcurrentSessions,")
        append("maxSessionsPerInstance=$maxSessionsPerInstance,")
        append("maxUserDurationInSeconds=$maxUserDurationInSeconds,")
        append("name=$name,")
        append("platform=$platform,")
        append("sessionScriptS3Location=$sessionScriptS3Location,")
        append("streamView=$streamView,")
        append("usbDeviceFilterStrings=$usbDeviceFilterStrings,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributesToDelete?.hashCode() ?: 0
        result = 31 * result + (computeCapacity?.hashCode() ?: 0)
        result = 31 * result + (deleteVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disconnectTimeoutInSeconds ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (domainJoinInfo?.hashCode() ?: 0)
        result = 31 * result + (enableDefaultInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idleDisconnectTimeoutInSeconds ?: 0)
        result = 31 * result + (imageArn?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrentSessions ?: 0)
        result = 31 * result + (maxSessionsPerInstance ?: 0)
        result = 31 * result + (maxUserDurationInSeconds ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (sessionScriptS3Location?.hashCode() ?: 0)
        result = 31 * result + (streamView?.hashCode() ?: 0)
        result = 31 * result + (usbDeviceFilterStrings?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFleetRequest

        if (attributesToDelete != other.attributesToDelete) return false
        if (computeCapacity != other.computeCapacity) return false
        if (deleteVpcConfig != other.deleteVpcConfig) return false
        if (description != other.description) return false
        if (disconnectTimeoutInSeconds != other.disconnectTimeoutInSeconds) return false
        if (displayName != other.displayName) return false
        if (domainJoinInfo != other.domainJoinInfo) return false
        if (enableDefaultInternetAccess != other.enableDefaultInternetAccess) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idleDisconnectTimeoutInSeconds != other.idleDisconnectTimeoutInSeconds) return false
        if (imageArn != other.imageArn) return false
        if (imageName != other.imageName) return false
        if (instanceType != other.instanceType) return false
        if (maxConcurrentSessions != other.maxConcurrentSessions) return false
        if (maxSessionsPerInstance != other.maxSessionsPerInstance) return false
        if (maxUserDurationInSeconds != other.maxUserDurationInSeconds) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (sessionScriptS3Location != other.sessionScriptS3Location) return false
        if (streamView != other.streamView) return false
        if (usbDeviceFilterStrings != other.usbDeviceFilterStrings) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.UpdateFleetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The fleet attributes to delete.
         */
        public var attributesToDelete: List<FleetAttribute>? = null
        /**
         * The desired capacity for the fleet. This is not allowed for Elastic fleets.
         */
        public var computeCapacity: aws.sdk.kotlin.services.appstream.model.ComputeCapacity? = null
        /**
         * Deletes the VPC association for the specified fleet.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var deleteVpcConfig: kotlin.Boolean? = null
        /**
         * The description to display.
         */
        public var description: kotlin.String? = null
        /**
         * The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
         *
         * Specify a value between 60 and 360000.
         */
        public var disconnectTimeoutInSeconds: kotlin.Int? = null
        /**
         * The fleet name to display.
         */
        public var displayName: kotlin.String? = null
        /**
         * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain.
         */
        public var domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = null
        /**
         * Enables or disables default internet access for the fleet.
         */
        public var enableDefaultInternetAccess: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
         *
         * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `DisconnectTimeoutInSeconds` time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in `DisconnectTimeoutInSeconds` elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
         *
         * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.
         *
         * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
         */
        public var idleDisconnectTimeoutInSeconds: kotlin.Int? = null
        /**
         * The ARN of the public, private, or shared image to use.
         */
        public var imageArn: kotlin.String? = null
        /**
         * The name of the image used to create the fleet.
         */
        public var imageName: kotlin.String? = null
        /**
         * The instance type to use when launching fleet instances. The following instance types are available:
         * + stream.standard.small
         * + stream.standard.medium
         * + stream.standard.large
         * + stream.standard.xlarge
         * + stream.standard.2xlarge
         * + stream.compute.large
         * + stream.compute.xlarge
         * + stream.compute.2xlarge
         * + stream.compute.4xlarge
         * + stream.compute.8xlarge
         * + stream.memory.large
         * + stream.memory.xlarge
         * + stream.memory.2xlarge
         * + stream.memory.4xlarge
         * + stream.memory.8xlarge
         * + stream.memory.z1d.large
         * + stream.memory.z1d.xlarge
         * + stream.memory.z1d.2xlarge
         * + stream.memory.z1d.3xlarge
         * + stream.memory.z1d.6xlarge
         * + stream.memory.z1d.12xlarge
         * + stream.graphics-design.large
         * + stream.graphics-design.xlarge
         * + stream.graphics-design.2xlarge
         * + stream.graphics-design.4xlarge
         * + stream.graphics-desktop.2xlarge
         * + stream.graphics.g4dn.xlarge
         * + stream.graphics.g4dn.2xlarge
         * + stream.graphics.g4dn.4xlarge
         * + stream.graphics.g4dn.8xlarge
         * + stream.graphics.g4dn.12xlarge
         * + stream.graphics.g4dn.16xlarge
         * + stream.graphics-pro.4xlarge
         * + stream.graphics-pro.8xlarge
         * + stream.graphics-pro.16xlarge
         *
         * The following instance types are available for Elastic fleets:
         * + stream.standard.small
         * + stream.standard.medium
         * + stream.standard.large
         * + stream.standard.xlarge
         * + stream.standard.2xlarge
         */
        public var instanceType: kotlin.String? = null
        /**
         * The maximum number of concurrent sessions for a fleet.
         */
        public var maxConcurrentSessions: kotlin.Int? = null
        /**
         * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
         */
        public var maxSessionsPerInstance: kotlin.Int? = null
        /**
         * The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
         *
         * Specify a value between 600 and 432000.
         */
        public var maxUserDurationInSeconds: kotlin.Int? = null
        /**
         * A unique name for the fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         */
        public var platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = null
        /**
         * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         */
        public var sessionScriptS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = null
        /**
         * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays.
         *
         * The default value is `APP`.
         */
        public var streamView: aws.sdk.kotlin.services.appstream.model.StreamView? = null
        /**
         * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.
         */
        public var usbDeviceFilterStrings: List<String>? = null
        /**
         * The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.
         */
        public var vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.UpdateFleetRequest) : this() {
            this.attributesToDelete = x.attributesToDelete
            this.computeCapacity = x.computeCapacity
            this.deleteVpcConfig = x.deleteVpcConfig
            this.description = x.description
            this.disconnectTimeoutInSeconds = x.disconnectTimeoutInSeconds
            this.displayName = x.displayName
            this.domainJoinInfo = x.domainJoinInfo
            this.enableDefaultInternetAccess = x.enableDefaultInternetAccess
            this.iamRoleArn = x.iamRoleArn
            this.idleDisconnectTimeoutInSeconds = x.idleDisconnectTimeoutInSeconds
            this.imageArn = x.imageArn
            this.imageName = x.imageName
            this.instanceType = x.instanceType
            this.maxConcurrentSessions = x.maxConcurrentSessions
            this.maxSessionsPerInstance = x.maxSessionsPerInstance
            this.maxUserDurationInSeconds = x.maxUserDurationInSeconds
            this.name = x.name
            this.platform = x.platform
            this.sessionScriptS3Location = x.sessionScriptS3Location
            this.streamView = x.streamView
            this.usbDeviceFilterStrings = x.usbDeviceFilterStrings
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.UpdateFleetRequest = UpdateFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ComputeCapacity] inside the given [block]
         */
        public fun computeCapacity(block: aws.sdk.kotlin.services.appstream.model.ComputeCapacity.Builder.() -> kotlin.Unit) {
            this.computeCapacity = aws.sdk.kotlin.services.appstream.model.ComputeCapacity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.DomainJoinInfo] inside the given [block]
         */
        public fun domainJoinInfo(block: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.Builder.() -> kotlin.Unit) {
            this.domainJoinInfo = aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.S3Location] inside the given [block]
         */
        public fun sessionScriptS3Location(block: aws.sdk.kotlin.services.appstream.model.S3Location.Builder.() -> kotlin.Unit) {
            this.sessionScriptS3Location = aws.sdk.kotlin.services.appstream.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.appstream.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.appstream.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
