// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.serde

import aws.sdk.kotlin.services.appstream.model.AppStreamException
import aws.sdk.kotlin.services.appstream.model.CreateUpdatedImageResponse
import aws.sdk.kotlin.services.appstream.model.Image
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUpdatedImageOperationDeserializer: HttpDeserialize<CreateUpdatedImageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateUpdatedImageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUpdatedImageError(context, call)
        }
        val builder = CreateUpdatedImageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUpdatedImageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateUpdatedImageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppStreamException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "IncompatibleImageException" -> IncompatibleImageExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAccountStatusException" -> InvalidAccountStatusExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppStreamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUpdatedImageOperationBody(builder: CreateUpdatedImageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CANUPDATEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("canUpdateImage"))
    val IMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("image"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CANUPDATEIMAGE_DESCRIPTOR)
        field(IMAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CANUPDATEIMAGE_DESCRIPTOR.index -> builder.canUpdateImage = deserializeBoolean()
                IMAGE_DESCRIPTOR.index -> builder.image = deserializeImageDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
