// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.serde

import aws.sdk.kotlin.services.appstream.model.AppStreamException
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockBuilderStreamingUrlResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateAppBlockBuilderStreamingURLOperationDeserializer: HttpDeserialize<CreateAppBlockBuilderStreamingUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAppBlockBuilderStreamingUrlResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAppBlockBuilderStreamingUrlError(context, call)
        }
        val builder = CreateAppBlockBuilderStreamingUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAppBlockBuilderStreamingURLOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAppBlockBuilderStreamingUrlError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppStreamException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppStreamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAppBlockBuilderStreamingURLOperationBody(builder: CreateAppBlockBuilderStreamingUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXPIRES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Expires"))
    val STREAMINGURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamingURL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPIRES_DESCRIPTOR)
        field(STREAMINGURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPIRES_DESCRIPTOR.index -> builder.expires = deserializeString().let { Instant.fromEpochSeconds(it) }
                STREAMINGURL_DESCRIPTOR.index -> builder.streamingUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
