// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



public class UpdateStackRequest private constructor(builder: Builder) {
    /**
     * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     */
    public val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.
     */
    public val applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettings? = builder.applicationSettings
    /**
     * The stack attributes to delete.
     */
    public val attributesToDelete: List<StackAttribute>? = builder.attributesToDelete
    /**
     * Deletes the storage connectors currently enabled for the stack.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val deleteStorageConnectors: kotlin.Boolean? = builder.deleteStorageConnectors
    /**
     * The description to display.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The stack name to display.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    public val embedHostDomains: List<String>? = builder.embedHostDomains
    /**
     * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
     */
    public val feedbackUrl: kotlin.String? = builder.feedbackUrl
    /**
     * The name of the stack.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The URL that users are redirected to after their streaming session ends.
     */
    public val redirectUrl: kotlin.String? = builder.redirectUrl
    /**
     * The storage connectors to enable.
     */
    public val storageConnectors: List<StorageConnector>? = builder.storageConnectors
    /**
     * The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     */
    public val streamingExperienceSettings: aws.sdk.kotlin.services.appstream.model.StreamingExperienceSettings? = builder.streamingExperienceSettings
    /**
     * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.
     */
    public val userSettings: List<UserSetting>? = builder.userSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStackRequest(")
        append("accessEndpoints=$accessEndpoints,")
        append("applicationSettings=$applicationSettings,")
        append("attributesToDelete=$attributesToDelete,")
        append("deleteStorageConnectors=$deleteStorageConnectors,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("embedHostDomains=$embedHostDomains,")
        append("feedbackUrl=$feedbackUrl,")
        append("name=$name,")
        append("redirectUrl=$redirectUrl,")
        append("storageConnectors=$storageConnectors,")
        append("streamingExperienceSettings=$streamingExperienceSettings,")
        append("userSettings=$userSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (applicationSettings?.hashCode() ?: 0)
        result = 31 * result + (attributesToDelete?.hashCode() ?: 0)
        result = 31 * result + (deleteStorageConnectors?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (embedHostDomains?.hashCode() ?: 0)
        result = 31 * result + (feedbackUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (redirectUrl?.hashCode() ?: 0)
        result = 31 * result + (storageConnectors?.hashCode() ?: 0)
        result = 31 * result + (streamingExperienceSettings?.hashCode() ?: 0)
        result = 31 * result + (userSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStackRequest

        if (accessEndpoints != other.accessEndpoints) return false
        if (applicationSettings != other.applicationSettings) return false
        if (attributesToDelete != other.attributesToDelete) return false
        if (deleteStorageConnectors != other.deleteStorageConnectors) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (embedHostDomains != other.embedHostDomains) return false
        if (feedbackUrl != other.feedbackUrl) return false
        if (name != other.name) return false
        if (redirectUrl != other.redirectUrl) return false
        if (storageConnectors != other.storageConnectors) return false
        if (streamingExperienceSettings != other.streamingExperienceSettings) return false
        if (userSettings != other.userSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
         */
        public var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.
         */
        public var applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettings? = null
        /**
         * The stack attributes to delete.
         */
        public var attributesToDelete: List<StackAttribute>? = null
        /**
         * Deletes the storage connectors currently enabled for the stack.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var deleteStorageConnectors: kotlin.Boolean? = null
        /**
         * The description to display.
         */
        public var description: kotlin.String? = null
        /**
         * The stack name to display.
         */
        public var displayName: kotlin.String? = null
        /**
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
         */
        public var embedHostDomains: List<String>? = null
        /**
         * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
         */
        public var feedbackUrl: kotlin.String? = null
        /**
         * The name of the stack.
         */
        public var name: kotlin.String? = null
        /**
         * The URL that users are redirected to after their streaming session ends.
         */
        public var redirectUrl: kotlin.String? = null
        /**
         * The storage connectors to enable.
         */
        public var storageConnectors: List<StorageConnector>? = null
        /**
         * The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
         */
        public var streamingExperienceSettings: aws.sdk.kotlin.services.appstream.model.StreamingExperienceSettings? = null
        /**
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.
         */
        public var userSettings: List<UserSetting>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.UpdateStackRequest) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.applicationSettings = x.applicationSettings
            this.attributesToDelete = x.attributesToDelete
            this.deleteStorageConnectors = x.deleteStorageConnectors
            this.description = x.description
            this.displayName = x.displayName
            this.embedHostDomains = x.embedHostDomains
            this.feedbackUrl = x.feedbackUrl
            this.name = x.name
            this.redirectUrl = x.redirectUrl
            this.storageConnectors = x.storageConnectors
            this.streamingExperienceSettings = x.streamingExperienceSettings
            this.userSettings = x.userSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = UpdateStackRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ApplicationSettings] inside the given [block]
         */
        public fun applicationSettings(block: aws.sdk.kotlin.services.appstream.model.ApplicationSettings.Builder.() -> kotlin.Unit) {
            this.applicationSettings = aws.sdk.kotlin.services.appstream.model.ApplicationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.StreamingExperienceSettings] inside the given [block]
         */
        public fun streamingExperienceSettings(block: aws.sdk.kotlin.services.appstream.model.StreamingExperienceSettings.Builder.() -> kotlin.Unit) {
            this.streamingExperienceSettings = aws.sdk.kotlin.services.appstream.model.StreamingExperienceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
