// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an image.
 */
public class Image private constructor(builder: Builder) {
    /**
     * The applications associated with the image.
     */
    public val applications: List<Application>? = builder.applications
    /**
     * The version of the AppStream 2.0 agent to use for instances that are launched from this image.
     */
    public val appstreamAgentVersion: kotlin.String? = builder.appstreamAgentVersion
    /**
     * The ARN of the image.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ARN of the image from which this image was created.
     */
    public val baseImageArn: kotlin.String? = builder.baseImageArn
    /**
     * The time the image was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description to display.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The image name to display.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the image builder that was used to create the private image. If the image is shared, this value is null.
     */
    public val imageBuilderName: kotlin.String? = builder.imageBuilderName
    /**
     * Indicates whether an image builder can be launched from this image.
     */
    public val imageBuilderSupported: kotlin.Boolean? = builder.imageBuilderSupported
    /**
     * Describes the errors that are returned when a new image can't be created.
     */
    public val imageErrors: List<ResourceError>? = builder.imageErrors
    /**
     * The permissions to provide to the destination AWS account for the specified image.
     */
    public val imagePermissions: aws.sdk.kotlin.services.appstream.model.ImagePermissions? = builder.imagePermissions
    /**
     * The name of the image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system platform of the image.
     */
    public val platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = builder.platform
    /**
     * The release date of the public base image. For private images, this date is the release date of the base image from which the image was created.
     */
    public val publicBaseImageReleasedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.publicBaseImageReleasedDate
    /**
     * The image starts in the `PENDING` state. If image creation succeeds, the state is `AVAILABLE`. If image creation fails, the state is `FAILED`.
     */
    public val state: aws.sdk.kotlin.services.appstream.model.ImageState? = builder.state
    /**
     * The reason why the last state change occurred.
     */
    public val stateChangeReason: aws.sdk.kotlin.services.appstream.model.ImageStateChangeReason? = builder.stateChangeReason
    /**
     * Indicates whether the image is public or private.
     */
    public val visibility: aws.sdk.kotlin.services.appstream.model.VisibilityType? = builder.visibility

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.Image = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("applications=$applications,")
        append("appstreamAgentVersion=$appstreamAgentVersion,")
        append("arn=$arn,")
        append("baseImageArn=$baseImageArn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("imageBuilderName=$imageBuilderName,")
        append("imageBuilderSupported=$imageBuilderSupported,")
        append("imageErrors=$imageErrors,")
        append("imagePermissions=$imagePermissions,")
        append("name=$name,")
        append("platform=$platform,")
        append("publicBaseImageReleasedDate=$publicBaseImageReleasedDate,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("visibility=$visibility")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applications?.hashCode() ?: 0
        result = 31 * result + (appstreamAgentVersion?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (baseImageArn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (imageBuilderName?.hashCode() ?: 0)
        result = 31 * result + (imageBuilderSupported?.hashCode() ?: 0)
        result = 31 * result + (imageErrors?.hashCode() ?: 0)
        result = 31 * result + (imagePermissions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (publicBaseImageReleasedDate?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (visibility?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Image

        if (applications != other.applications) return false
        if (appstreamAgentVersion != other.appstreamAgentVersion) return false
        if (arn != other.arn) return false
        if (baseImageArn != other.baseImageArn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (imageBuilderName != other.imageBuilderName) return false
        if (imageBuilderSupported != other.imageBuilderSupported) return false
        if (imageErrors != other.imageErrors) return false
        if (imagePermissions != other.imagePermissions) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (publicBaseImageReleasedDate != other.publicBaseImageReleasedDate) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (visibility != other.visibility) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.Image = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The applications associated with the image.
         */
        public var applications: List<Application>? = null
        /**
         * The version of the AppStream 2.0 agent to use for instances that are launched from this image.
         */
        public var appstreamAgentVersion: kotlin.String? = null
        /**
         * The ARN of the image.
         */
        public var arn: kotlin.String? = null
        /**
         * The ARN of the image from which this image was created.
         */
        public var baseImageArn: kotlin.String? = null
        /**
         * The time the image was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description to display.
         */
        public var description: kotlin.String? = null
        /**
         * The image name to display.
         */
        public var displayName: kotlin.String? = null
        /**
         * The name of the image builder that was used to create the private image. If the image is shared, this value is null.
         */
        public var imageBuilderName: kotlin.String? = null
        /**
         * Indicates whether an image builder can be launched from this image.
         */
        public var imageBuilderSupported: kotlin.Boolean? = null
        /**
         * Describes the errors that are returned when a new image can't be created.
         */
        public var imageErrors: List<ResourceError>? = null
        /**
         * The permissions to provide to the destination AWS account for the specified image.
         */
        public var imagePermissions: aws.sdk.kotlin.services.appstream.model.ImagePermissions? = null
        /**
         * The name of the image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system platform of the image.
         */
        public var platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = null
        /**
         * The release date of the public base image. For private images, this date is the release date of the base image from which the image was created.
         */
        public var publicBaseImageReleasedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The image starts in the `PENDING` state. If image creation succeeds, the state is `AVAILABLE`. If image creation fails, the state is `FAILED`.
         */
        public var state: aws.sdk.kotlin.services.appstream.model.ImageState? = null
        /**
         * The reason why the last state change occurred.
         */
        public var stateChangeReason: aws.sdk.kotlin.services.appstream.model.ImageStateChangeReason? = null
        /**
         * Indicates whether the image is public or private.
         */
        public var visibility: aws.sdk.kotlin.services.appstream.model.VisibilityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.Image) : this() {
            this.applications = x.applications
            this.appstreamAgentVersion = x.appstreamAgentVersion
            this.arn = x.arn
            this.baseImageArn = x.baseImageArn
            this.createdTime = x.createdTime
            this.description = x.description
            this.displayName = x.displayName
            this.imageBuilderName = x.imageBuilderName
            this.imageBuilderSupported = x.imageBuilderSupported
            this.imageErrors = x.imageErrors
            this.imagePermissions = x.imagePermissions
            this.name = x.name
            this.platform = x.platform
            this.publicBaseImageReleasedDate = x.publicBaseImageReleasedDate
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.visibility = x.visibility
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.Image = Image(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ImagePermissions] inside the given [block]
         */
        public fun imagePermissions(block: aws.sdk.kotlin.services.appstream.model.ImagePermissions.Builder.() -> kotlin.Unit) {
            this.imagePermissions = aws.sdk.kotlin.services.appstream.model.ImagePermissions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ImageStateChangeReason] inside the given [block]
         */
        public fun stateChangeReason(block: aws.sdk.kotlin.services.appstream.model.ImageStateChangeReason.Builder.() -> kotlin.Unit) {
            this.stateChangeReason = aws.sdk.kotlin.services.appstream.model.ImageStateChangeReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
