// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



/**
 * An attribute associated with an entitlement. Application entitlements work by matching a supported SAML 2.0 attribute name to a value when a user identity federates to an Amazon AppStream 2.0 SAML application.
 */
public class EntitlementAttribute private constructor(builder: Builder) {
    /**
     * A supported AWS IAM SAML `PrincipalTag` attribute that is matched to the associated value when a user identity federates into an Amazon AppStream 2.0 SAML application.
     *
     * The following are valid values:
     * + roles
     * + department
     * + organization
     * + groups
     * + title
     * + costCenter
     * + userType
     */
    public val name: kotlin.String? = builder.name
    /**
     * A value that is matched to a supported SAML attribute name when a user identity federates into an Amazon AppStream 2.0 SAML application.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.EntitlementAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntitlementAttribute(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntitlementAttribute

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.EntitlementAttribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A supported AWS IAM SAML `PrincipalTag` attribute that is matched to the associated value when a user identity federates into an Amazon AppStream 2.0 SAML application.
         *
         * The following are valid values:
         * + roles
         * + department
         * + organization
         * + groups
         * + title
         * + costCenter
         * + userType
         */
        public var name: kotlin.String? = null
        /**
         * A value that is matched to a supported SAML attribute name when a user identity federates into an Amazon AppStream 2.0 SAML application.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.EntitlementAttribute) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.EntitlementAttribute = EntitlementAttribute(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
