// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



/**
 * Describes an interface VPC endpoint (interface endpoint) that lets you create a private connection between the virtual private cloud (VPC) that you specify and AppStream 2.0. When you specify an interface endpoint for a stack, users of the stack can connect to AppStream 2.0 only through that endpoint. When you specify an interface endpoint for an image builder, administrators can connect to the image builder only through that endpoint.
 */
public class AccessEndpoint private constructor(builder: Builder) {
    /**
     * The type of interface endpoint.
     */
    public val endpointType: aws.sdk.kotlin.services.appstream.model.AccessEndpointType? = builder.endpointType
    /**
     * The identifier (ID) of the VPC in which the interface endpoint is used.
     */
    public val vpceId: kotlin.String? = builder.vpceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.AccessEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessEndpoint(")
        append("endpointType=$endpointType,")
        append("vpceId=$vpceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointType?.hashCode() ?: 0
        result = 31 * result + (vpceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessEndpoint

        if (endpointType != other.endpointType) return false
        if (vpceId != other.vpceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.AccessEndpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of interface endpoint.
         */
        public var endpointType: aws.sdk.kotlin.services.appstream.model.AccessEndpointType? = null
        /**
         * The identifier (ID) of the VPC in which the interface endpoint is used.
         */
        public var vpceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.AccessEndpoint) : this() {
            this.endpointType = x.endpointType
            this.vpceId = x.vpceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.AccessEndpoint = AccessEndpoint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
