// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



/**
 * Describes the S3 location.
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * The S3 bucket of the S3 object.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The S3 key of the S3 object.
     *
     * This is required when used for the following:
     * + IconS3Location (Actions: CreateApplication and UpdateApplication)
     * + SessionScriptS3Location (Actions: CreateFleet and UpdateFleet)
     * + ScriptDetails (Actions: CreateAppBlock)
     * + SourceS3Location when creating an app block with `CUSTOM` PackagingType (Actions: CreateAppBlock)
     * + SourceS3Location when creating an app block with `APPSTREAM2` PackagingType, and using an existing application package (VHD file). In this case, `S3Key` refers to the VHD file. If a new application package is required, then `S3Key` is not required. (Actions: CreateAppBlock)
     */
    public val s3Key: kotlin.String? = builder.s3Key

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket?.hashCode() ?: 0
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.S3Location = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 bucket of the S3 object.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The S3 key of the S3 object.
         *
         * This is required when used for the following:
         * + IconS3Location (Actions: CreateApplication and UpdateApplication)
         * + SessionScriptS3Location (Actions: CreateFleet and UpdateFleet)
         * + ScriptDetails (Actions: CreateAppBlock)
         * + SourceS3Location when creating an app block with `CUSTOM` PackagingType (Actions: CreateAppBlock)
         * + SourceS3Location when creating an app block with `APPSTREAM2` PackagingType, and using an existing application package (VHD file). In this case, `S3Key` refers to the VHD file. If a new application package is required, then `S3Key` is not required. (Actions: CreateAppBlock)
         */
        public var s3Key: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.S3Location) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.S3Location = S3Location(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
