// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



/**
 * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. Fallback is turned on by default when certificate-based authentication is **Enabled** . Fallback allows users to log in using their AD domain password if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen. **Enabled_no_directory_login_fallback** enables certificate-based authentication, but does not allow users to log in using their AD domain password. Users will be disconnected to re-authenticate using certificates.
 */
public class CertificateBasedAuthProperties private constructor(builder: Builder) {
    /**
     * The ARN of the AWS Certificate Manager Private CA resource.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The status of the certificate-based authentication properties.
     */
    public val status: aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateBasedAuthProperties(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateBasedAuthProperties

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the AWS Certificate Manager Private CA resource.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The status of the certificate-based authentication properties.
         */
        public var status: aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthProperties) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CertificateBasedAuthProperties = CertificateBasedAuthProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
