// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appstream.auth.AppStreamAuthSchemeProvider
import aws.sdk.kotlin.services.appstream.auth.DefaultAppStreamAuthSchemeProvider
import aws.sdk.kotlin.services.appstream.endpoints.AppStreamEndpointParameters
import aws.sdk.kotlin.services.appstream.endpoints.AppStreamEndpointProvider
import aws.sdk.kotlin.services.appstream.endpoints.DefaultAppStreamEndpointProvider
import aws.sdk.kotlin.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest
import aws.sdk.kotlin.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse
import aws.sdk.kotlin.services.appstream.model.AssociateApplicationFleetRequest
import aws.sdk.kotlin.services.appstream.model.AssociateApplicationFleetResponse
import aws.sdk.kotlin.services.appstream.model.AssociateApplicationToEntitlementRequest
import aws.sdk.kotlin.services.appstream.model.AssociateApplicationToEntitlementResponse
import aws.sdk.kotlin.services.appstream.model.AssociateFleetRequest
import aws.sdk.kotlin.services.appstream.model.AssociateFleetResponse
import aws.sdk.kotlin.services.appstream.model.BatchAssociateUserStackRequest
import aws.sdk.kotlin.services.appstream.model.BatchAssociateUserStackResponse
import aws.sdk.kotlin.services.appstream.model.BatchDisassociateUserStackRequest
import aws.sdk.kotlin.services.appstream.model.BatchDisassociateUserStackResponse
import aws.sdk.kotlin.services.appstream.model.CopyImageRequest
import aws.sdk.kotlin.services.appstream.model.CopyImageResponse
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockBuilderRequest
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockBuilderResponse
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockBuilderStreamingUrlResponse
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockRequest
import aws.sdk.kotlin.services.appstream.model.CreateAppBlockResponse
import aws.sdk.kotlin.services.appstream.model.CreateApplicationRequest
import aws.sdk.kotlin.services.appstream.model.CreateApplicationResponse
import aws.sdk.kotlin.services.appstream.model.CreateDirectoryConfigRequest
import aws.sdk.kotlin.services.appstream.model.CreateDirectoryConfigResponse
import aws.sdk.kotlin.services.appstream.model.CreateEntitlementRequest
import aws.sdk.kotlin.services.appstream.model.CreateEntitlementResponse
import aws.sdk.kotlin.services.appstream.model.CreateFleetRequest
import aws.sdk.kotlin.services.appstream.model.CreateFleetResponse
import aws.sdk.kotlin.services.appstream.model.CreateImageBuilderRequest
import aws.sdk.kotlin.services.appstream.model.CreateImageBuilderResponse
import aws.sdk.kotlin.services.appstream.model.CreateImageBuilderStreamingUrlRequest
import aws.sdk.kotlin.services.appstream.model.CreateImageBuilderStreamingUrlResponse
import aws.sdk.kotlin.services.appstream.model.CreateStackRequest
import aws.sdk.kotlin.services.appstream.model.CreateStackResponse
import aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlRequest
import aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlResponse
import aws.sdk.kotlin.services.appstream.model.CreateUpdatedImageRequest
import aws.sdk.kotlin.services.appstream.model.CreateUpdatedImageResponse
import aws.sdk.kotlin.services.appstream.model.CreateUsageReportSubscriptionRequest
import aws.sdk.kotlin.services.appstream.model.CreateUsageReportSubscriptionResponse
import aws.sdk.kotlin.services.appstream.model.CreateUserRequest
import aws.sdk.kotlin.services.appstream.model.CreateUserResponse
import aws.sdk.kotlin.services.appstream.model.DeleteAppBlockBuilderRequest
import aws.sdk.kotlin.services.appstream.model.DeleteAppBlockBuilderResponse
import aws.sdk.kotlin.services.appstream.model.DeleteAppBlockRequest
import aws.sdk.kotlin.services.appstream.model.DeleteAppBlockResponse
import aws.sdk.kotlin.services.appstream.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.appstream.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.appstream.model.DeleteDirectoryConfigRequest
import aws.sdk.kotlin.services.appstream.model.DeleteDirectoryConfigResponse
import aws.sdk.kotlin.services.appstream.model.DeleteEntitlementRequest
import aws.sdk.kotlin.services.appstream.model.DeleteEntitlementResponse
import aws.sdk.kotlin.services.appstream.model.DeleteFleetRequest
import aws.sdk.kotlin.services.appstream.model.DeleteFleetResponse
import aws.sdk.kotlin.services.appstream.model.DeleteImageBuilderRequest
import aws.sdk.kotlin.services.appstream.model.DeleteImageBuilderResponse
import aws.sdk.kotlin.services.appstream.model.DeleteImagePermissionsRequest
import aws.sdk.kotlin.services.appstream.model.DeleteImagePermissionsResponse
import aws.sdk.kotlin.services.appstream.model.DeleteImageRequest
import aws.sdk.kotlin.services.appstream.model.DeleteImageResponse
import aws.sdk.kotlin.services.appstream.model.DeleteStackRequest
import aws.sdk.kotlin.services.appstream.model.DeleteStackResponse
import aws.sdk.kotlin.services.appstream.model.DeleteUsageReportSubscriptionRequest
import aws.sdk.kotlin.services.appstream.model.DeleteUsageReportSubscriptionResponse
import aws.sdk.kotlin.services.appstream.model.DeleteUserRequest
import aws.sdk.kotlin.services.appstream.model.DeleteUserResponse
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuildersRequest
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlockBuildersResponse
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlocksRequest
import aws.sdk.kotlin.services.appstream.model.DescribeAppBlocksResponse
import aws.sdk.kotlin.services.appstream.model.DescribeApplicationFleetAssociationsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeApplicationFleetAssociationsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeApplicationsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeApplicationsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeDirectoryConfigsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeDirectoryConfigsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeEntitlementsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeEntitlementsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeImageBuildersRequest
import aws.sdk.kotlin.services.appstream.model.DescribeImageBuildersResponse
import aws.sdk.kotlin.services.appstream.model.DescribeImagePermissionsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeImagePermissionsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeImagesRequest
import aws.sdk.kotlin.services.appstream.model.DescribeImagesResponse
import aws.sdk.kotlin.services.appstream.model.DescribeSessionsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeSessionsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeStacksRequest
import aws.sdk.kotlin.services.appstream.model.DescribeStacksResponse
import aws.sdk.kotlin.services.appstream.model.DescribeUsageReportSubscriptionsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeUsageReportSubscriptionsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeUserStackAssociationsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeUserStackAssociationsResponse
import aws.sdk.kotlin.services.appstream.model.DescribeUsersRequest
import aws.sdk.kotlin.services.appstream.model.DescribeUsersResponse
import aws.sdk.kotlin.services.appstream.model.DisableUserRequest
import aws.sdk.kotlin.services.appstream.model.DisableUserResponse
import aws.sdk.kotlin.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
import aws.sdk.kotlin.services.appstream.model.DisassociateAppBlockBuilderAppBlockResponse
import aws.sdk.kotlin.services.appstream.model.DisassociateApplicationFleetRequest
import aws.sdk.kotlin.services.appstream.model.DisassociateApplicationFleetResponse
import aws.sdk.kotlin.services.appstream.model.DisassociateApplicationFromEntitlementRequest
import aws.sdk.kotlin.services.appstream.model.DisassociateApplicationFromEntitlementResponse
import aws.sdk.kotlin.services.appstream.model.DisassociateFleetRequest
import aws.sdk.kotlin.services.appstream.model.DisassociateFleetResponse
import aws.sdk.kotlin.services.appstream.model.EnableUserRequest
import aws.sdk.kotlin.services.appstream.model.EnableUserResponse
import aws.sdk.kotlin.services.appstream.model.ExpireSessionRequest
import aws.sdk.kotlin.services.appstream.model.ExpireSessionResponse
import aws.sdk.kotlin.services.appstream.model.ListAssociatedFleetsRequest
import aws.sdk.kotlin.services.appstream.model.ListAssociatedFleetsResponse
import aws.sdk.kotlin.services.appstream.model.ListAssociatedStacksRequest
import aws.sdk.kotlin.services.appstream.model.ListAssociatedStacksResponse
import aws.sdk.kotlin.services.appstream.model.ListEntitledApplicationsRequest
import aws.sdk.kotlin.services.appstream.model.ListEntitledApplicationsResponse
import aws.sdk.kotlin.services.appstream.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appstream.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appstream.model.StartAppBlockBuilderRequest
import aws.sdk.kotlin.services.appstream.model.StartAppBlockBuilderResponse
import aws.sdk.kotlin.services.appstream.model.StartFleetRequest
import aws.sdk.kotlin.services.appstream.model.StartFleetResponse
import aws.sdk.kotlin.services.appstream.model.StartImageBuilderRequest
import aws.sdk.kotlin.services.appstream.model.StartImageBuilderResponse
import aws.sdk.kotlin.services.appstream.model.StopAppBlockBuilderRequest
import aws.sdk.kotlin.services.appstream.model.StopAppBlockBuilderResponse
import aws.sdk.kotlin.services.appstream.model.StopFleetRequest
import aws.sdk.kotlin.services.appstream.model.StopFleetResponse
import aws.sdk.kotlin.services.appstream.model.StopImageBuilderRequest
import aws.sdk.kotlin.services.appstream.model.StopImageBuilderResponse
import aws.sdk.kotlin.services.appstream.model.TagResourceRequest
import aws.sdk.kotlin.services.appstream.model.TagResourceResponse
import aws.sdk.kotlin.services.appstream.model.UntagResourceRequest
import aws.sdk.kotlin.services.appstream.model.UntagResourceResponse
import aws.sdk.kotlin.services.appstream.model.UpdateAppBlockBuilderRequest
import aws.sdk.kotlin.services.appstream.model.UpdateAppBlockBuilderResponse
import aws.sdk.kotlin.services.appstream.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.appstream.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.appstream.model.UpdateDirectoryConfigRequest
import aws.sdk.kotlin.services.appstream.model.UpdateDirectoryConfigResponse
import aws.sdk.kotlin.services.appstream.model.UpdateEntitlementRequest
import aws.sdk.kotlin.services.appstream.model.UpdateEntitlementResponse
import aws.sdk.kotlin.services.appstream.model.UpdateFleetRequest
import aws.sdk.kotlin.services.appstream.model.UpdateFleetResponse
import aws.sdk.kotlin.services.appstream.model.UpdateImagePermissionsRequest
import aws.sdk.kotlin.services.appstream.model.UpdateImagePermissionsResponse
import aws.sdk.kotlin.services.appstream.model.UpdateStackRequest
import aws.sdk.kotlin.services.appstream.model.UpdateStackResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppStream"
public const val SdkVersion: String = "1.0.24"
public const val ServiceApiVersion: String = "2016-12-01"

/**
 * # Amazon AppStream 2.0
 * This is the *Amazon AppStream 2.0 API Reference*. This documentation provides descriptions and syntax for each of the actions and data types in AppStream 2.0. AppStream 2.0 is a fully managed, secure application streaming service that lets you stream desktop applications to users without rewriting applications. AppStream 2.0 manages the AWS resources that are required to host and run your applications, scales automatically, and provides access to your users on demand.
 *
 * You can call the AppStream 2.0 API operations by using an interface VPC endpoint (interface endpoint). For more information, see [Access AppStream 2.0 API Operations and CLI Commands Through an Interface VPC Endpoint](https://docs.aws.amazon.com/appstream2/latest/developerguide/access-api-cli-through-interface-vpc-endpoint.html) in the *Amazon AppStream 2.0 Administration Guide*.
 *
 * To learn more about AppStream 2.0, see the following resources:
 * + [Amazon AppStream 2.0 product page](http://aws.amazon.com/appstream2)
 * + [Amazon AppStream 2.0 documentation](http://aws.amazon.com/documentation/appstream2)
 */
public interface AppStreamClient : SdkClient {
    /**
     * AppStreamClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppStreamClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppStream",
                "APPSTREAM",
                "appstream",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppStreamClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppStreamClient = DefaultAppStreamClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppStreamEndpointProvider = builder.endpointProvider ?: DefaultAppStreamEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppStreamAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppStreamAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppStream"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppStreamEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppStreamAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the specified app block builder with the specified app block.
     */
    public suspend fun associateAppBlockBuilderAppBlock(input: AssociateAppBlockBuilderAppBlockRequest): AssociateAppBlockBuilderAppBlockResponse

    /**
     * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
     */
    public suspend fun associateApplicationFleet(input: AssociateApplicationFleetRequest): AssociateApplicationFleetResponse

    /**
     * Associates an application to entitle.
     */
    public suspend fun associateApplicationToEntitlement(input: AssociateApplicationToEntitlementRequest): AssociateApplicationToEntitlementResponse

    /**
     * Associates the specified fleet with the specified stack.
     */
    public suspend fun associateFleet(input: AssociateFleetRequest): AssociateFleetResponse

    /**
     * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.
     */
    public suspend fun batchAssociateUserStack(input: BatchAssociateUserStackRequest): BatchAssociateUserStackResponse

    /**
     * Disassociates the specified users from the specified stacks.
     */
    public suspend fun batchDisassociateUserStack(input: BatchDisassociateUserStackRequest): BatchDisassociateUserStackResponse

    /**
     * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.
     */
    public suspend fun copyImage(input: CopyImageRequest): CopyImageResponse

    /**
     * Creates an app block.
     *
     * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes the application binaries and other files necessary to launch your applications. Multiple applications can be assigned to a single app block.
     *
     * This is only supported for Elastic fleets.
     */
    public suspend fun createAppBlock(input: CreateAppBlockRequest): CreateAppBlockResponse

    /**
     * Creates an app block builder.
     */
    public suspend fun createAppBlockBuilder(input: CreateAppBlockBuilderRequest): CreateAppBlockBuilderResponse

    /**
     * Creates a URL to start a create app block builder streaming session.
     */
    public suspend fun createAppBlockBuilderStreamingUrl(input: CreateAppBlockBuilderStreamingUrlRequest): CreateAppBlockBuilderStreamingUrlResponse

    /**
     * Creates an application.
     *
     * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on Elastic fleet streaming instances. An application consists of the launch details, icon, and display name. Applications are associated with an app block that contains the application binaries and other files. The applications assigned to an Elastic fleet are the applications users can launch.
     *
     * This is only supported for Elastic fleets.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     */
    public suspend fun createDirectoryConfig(input: CreateDirectoryConfigRequest): CreateDirectoryConfigResponse

    /**
     * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
     */
    public suspend fun createEntitlement(input: CreateEntitlementRequest): CreateEntitlementResponse

    /**
     * Creates a fleet. A fleet consists of streaming instances that your users access for their applications and desktops.
     */
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates an image builder. An image builder is a virtual machine that is used to create an image.
     *
     * The initial state of the builder is `PENDING`. When it is ready, the state is `RUNNING`.
     */
    public suspend fun createImageBuilder(input: CreateImageBuilderRequest): CreateImageBuilderResponse

    /**
     * Creates a URL to start an image builder streaming session.
     */
    public suspend fun createImageBuilderStreamingUrl(input: CreateImageBuilderStreamingUrlRequest): CreateImageBuilderStreamingUrlResponse

    /**
     * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.
     */
    public suspend fun createStack(input: CreateStackRequest): CreateStackResponse

    /**
     * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.
     */
    public suspend fun createStreamingUrl(input: CreateStreamingUrlRequest): CreateStreamingUrlResponse

    /**
     * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.
     *
     * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in [Administer Your AppStream 2.0 Images](https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html), in the *Amazon AppStream 2.0 Administration Guide*.
     */
    public suspend fun createUpdatedImage(input: CreateUpdatedImageRequest): CreateUpdatedImageResponse

    /**
     * Creates a usage report subscription. Usage reports are generated daily.
     */
    public suspend fun createUsageReportSubscription(input: CreateUsageReportSubscriptionRequest = CreateUsageReportSubscriptionRequest { }): CreateUsageReportSubscriptionResponse

    /**
     * Creates a new user in the user pool.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deletes an app block.
     */
    public suspend fun deleteAppBlock(input: DeleteAppBlockRequest): DeleteAppBlockResponse

    /**
     * Deletes an app block builder.
     *
     * An app block builder can only be deleted when it has no association with an app block.
     */
    public suspend fun deleteAppBlockBuilder(input: DeleteAppBlockBuilderRequest): DeleteAppBlockBuilderResponse

    /**
     * Deletes an application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.
     */
    public suspend fun deleteDirectoryConfig(input: DeleteDirectoryConfigRequest): DeleteDirectoryConfigResponse

    /**
     * Deletes the specified entitlement.
     */
    public suspend fun deleteEntitlement(input: DeleteEntitlementRequest): DeleteEntitlementResponse

    /**
     * Deletes the specified fleet.
     */
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.
     */
    public suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse

    /**
     * Deletes the specified image builder and releases the capacity.
     */
    public suspend fun deleteImageBuilder(input: DeleteImageBuilderRequest): DeleteImageBuilderResponse

    /**
     * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.
     */
    public suspend fun deleteImagePermissions(input: DeleteImagePermissionsRequest): DeleteImagePermissionsResponse

    /**
     * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.
     */
    public suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse

    /**
     * Disables usage report generation.
     */
    public suspend fun deleteUsageReportSubscription(input: DeleteUsageReportSubscriptionRequest = DeleteUsageReportSubscriptionRequest { }): DeleteUsageReportSubscriptionResponse

    /**
     * Deletes a user from the user pool.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Retrieves a list that describes one or more app block builder associations.
     */
    public suspend fun describeAppBlockBuilderAppBlockAssociations(input: DescribeAppBlockBuilderAppBlockAssociationsRequest = DescribeAppBlockBuilderAppBlockAssociationsRequest { }): DescribeAppBlockBuilderAppBlockAssociationsResponse

    /**
     * Retrieves a list that describes one or more app block builders.
     */
    public suspend fun describeAppBlockBuilders(input: DescribeAppBlockBuildersRequest = DescribeAppBlockBuildersRequest { }): DescribeAppBlockBuildersResponse

    /**
     * Retrieves a list that describes one or more app blocks.
     */
    public suspend fun describeAppBlocks(input: DescribeAppBlocksRequest = DescribeAppBlocksRequest { }): DescribeAppBlocksResponse

    /**
     * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName must be specified.
     */
    public suspend fun describeApplicationFleetAssociations(input: DescribeApplicationFleetAssociationsRequest = DescribeApplicationFleetAssociationsRequest { }): DescribeApplicationFleetAssociationsResponse

    /**
     * Retrieves a list that describes one or more applications.
     */
    public suspend fun describeApplications(input: DescribeApplicationsRequest = DescribeApplicationsRequest { }): DescribeApplicationsResponse

    /**
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     *
     * Although the response syntax in this topic includes the account password, this password is not returned in the actual response.
     */
    public suspend fun describeDirectoryConfigs(input: DescribeDirectoryConfigsRequest = DescribeDirectoryConfigsRequest { }): DescribeDirectoryConfigsResponse

    /**
     * Retrieves a list that describes one of more entitlements.
     */
    public suspend fun describeEntitlements(input: DescribeEntitlementsRequest): DescribeEntitlementsResponse

    /**
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.
     */
    public suspend fun describeFleets(input: DescribeFleetsRequest = DescribeFleetsRequest { }): DescribeFleetsResponse

    /**
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.
     */
    public suspend fun describeImageBuilders(input: DescribeImageBuildersRequest = DescribeImageBuildersRequest { }): DescribeImageBuildersResponse

    /**
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     */
    public suspend fun describeImagePermissions(input: DescribeImagePermissionsRequest): DescribeImagePermissionsResponse

    /**
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.
     */
    public suspend fun describeImages(input: DescribeImagesRequest = DescribeImagesRequest { }): DescribeImagesResponse

    /**
     * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.
     */
    public suspend fun describeSessions(input: DescribeSessionsRequest): DescribeSessionsResponse

    /**
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.
     */
    public suspend fun describeStacks(input: DescribeStacksRequest = DescribeStacksRequest { }): DescribeStacksResponse

    /**
     * Retrieves a list that describes one or more usage report subscriptions.
     */
    public suspend fun describeUsageReportSubscriptions(input: DescribeUsageReportSubscriptionsRequest = DescribeUsageReportSubscriptionsRequest { }): DescribeUsageReportSubscriptionsResponse

    /**
     * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:
     * + The stack name
     * + The user name (email address of the user associated with the stack) and the authentication type for the user
     */
    public suspend fun describeUserStackAssociations(input: DescribeUserStackAssociationsRequest = DescribeUserStackAssociationsRequest { }): DescribeUserStackAssociationsResponse

    /**
     * Retrieves a list that describes one or more specified users in the user pool.
     */
    public suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse

    /**
     * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user.
     */
    public suspend fun disableUser(input: DisableUserRequest): DisableUserResponse

    /**
     * Disassociates a specified app block builder from a specified app block.
     */
    public suspend fun disassociateAppBlockBuilderAppBlock(input: DisassociateAppBlockBuilderAppBlockRequest): DisassociateAppBlockBuilderAppBlockResponse

    /**
     * Disassociates the specified application from the fleet.
     */
    public suspend fun disassociateApplicationFleet(input: DisassociateApplicationFleetRequest): DisassociateApplicationFleetResponse

    /**
     * Deletes the specified application from the specified entitlement.
     */
    public suspend fun disassociateApplicationFromEntitlement(input: DisassociateApplicationFromEntitlementRequest): DisassociateApplicationFromEntitlementResponse

    /**
     * Disassociates the specified fleet from the specified stack.
     */
    public suspend fun disassociateFleet(input: DisassociateFleetRequest): DisassociateFleetResponse

    /**
     * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.
     */
    public suspend fun enableUser(input: EnableUserRequest): EnableUserResponse

    /**
     * Immediately stops the specified streaming session.
     */
    public suspend fun expireSession(input: ExpireSessionRequest): ExpireSessionResponse

    /**
     * Retrieves the name of the fleet that is associated with the specified stack.
     */
    public suspend fun listAssociatedFleets(input: ListAssociatedFleetsRequest): ListAssociatedFleetsResponse

    /**
     * Retrieves the name of the stack with which the specified fleet is associated.
     */
    public suspend fun listAssociatedStacks(input: ListAssociatedStacksRequest): ListAssociatedStacksResponse

    /**
     * Retrieves a list of entitled applications.
     */
    public suspend fun listEntitledApplications(input: ListEntitledApplicationsRequest): ListEntitledApplicationsResponse

    /**
     * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts an app block builder.
     *
     * An app block builder can only be started when it's associated with an app block.
     *
     * Starting an app block builder starts a new instance, which is equivalent to an elastic fleet instance with application builder assistance functionality.
     */
    public suspend fun startAppBlockBuilder(input: StartAppBlockBuilderRequest): StartAppBlockBuilderResponse

    /**
     * Starts the specified fleet.
     */
    public suspend fun startFleet(input: StartFleetRequest): StartFleetResponse

    /**
     * Starts the specified image builder.
     */
    public suspend fun startImageBuilder(input: StartImageBuilderRequest): StartImageBuilderResponse

    /**
     * Stops an app block builder.
     *
     * Stopping an app block builder terminates the instance, and the instance state is not persisted.
     */
    public suspend fun stopAppBlockBuilder(input: StopAppBlockBuilderRequest): StopAppBlockBuilderResponse

    /**
     * Stops the specified fleet.
     */
    public suspend fun stopFleet(input: StopFleetRequest): StopFleetResponse

    /**
     * Stops the specified image builder.
     */
    public suspend fun stopImageBuilder(input: StopImageBuilderRequest): StopImageBuilderResponse

    /**
     * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
     *
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     *
     * To list the current tags for your resources, use ListTagsForResource. To disassociate tags from your resources, use UntagResource.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
     *
     * To list the current tags for your resources, use ListTagsForResource.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an app block builder.
     *
     * If the app block builder is in the `STARTING` or `STOPPING` state, you can't update it. If the app block builder is in the `RUNNING` state, you can only update the DisplayName and Description. If the app block builder is in the `STOPPED` state, you can update any attribute except the Name.
     */
    public suspend fun updateAppBlockBuilder(input: UpdateAppBlockBuilderRequest): UpdateAppBlockBuilderResponse

    /**
     * Updates the specified application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     */
    public suspend fun updateDirectoryConfig(input: UpdateDirectoryConfigRequest): UpdateDirectoryConfigResponse

    /**
     * Updates the specified entitlement.
     */
    public suspend fun updateEntitlement(input: UpdateEntitlementRequest): UpdateEntitlementResponse

    /**
     * Updates the specified fleet.
     *
     * If the fleet is in the `STOPPED` state, you can update any attribute except the fleet name.
     *
     * If the fleet is in the `RUNNING` state, you can update the following based on the fleet type:
     * + Always-On and On-Demand fleet typesYou can update the `DisplayName`, `ComputeCapacity`, `ImageARN`, `ImageName`, `IdleDisconnectTimeoutInSeconds`, and `DisconnectTimeoutInSeconds` attributes.
     * + Elastic fleet typeYou can update the `DisplayName`, `IdleDisconnectTimeoutInSeconds`, `DisconnectTimeoutInSeconds`, `MaxConcurrentSessions`, `SessionScriptS3Location` and `UsbDeviceFilterStrings` attributes.
     *
     * If the fleet is in the `STARTING` or `STOPPED` state, you can't update it.
     */
    public suspend fun updateFleet(input: UpdateFleetRequest = UpdateFleetRequest { }): UpdateFleetResponse

    /**
     * Adds or updates permissions for the specified private image.
     */
    public suspend fun updateImagePermissions(input: UpdateImagePermissionsRequest): UpdateImagePermissionsResponse

    /**
     * Updates the specified fields for the specified stack.
     */
    public suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppStreamClient.withConfig(block: AppStreamClient.Config.Builder.() -> Unit): AppStreamClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppStreamClient(newConfig)
}

/**
 * Associates the specified app block builder with the specified app block.
 */
public suspend inline fun AppStreamClient.associateAppBlockBuilderAppBlock(crossinline block: AssociateAppBlockBuilderAppBlockRequest.Builder.() -> Unit): AssociateAppBlockBuilderAppBlockResponse = associateAppBlockBuilderAppBlock(AssociateAppBlockBuilderAppBlockRequest.Builder().apply(block).build())

/**
 * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
 */
public suspend inline fun AppStreamClient.associateApplicationFleet(crossinline block: AssociateApplicationFleetRequest.Builder.() -> Unit): AssociateApplicationFleetResponse = associateApplicationFleet(AssociateApplicationFleetRequest.Builder().apply(block).build())

/**
 * Associates an application to entitle.
 */
public suspend inline fun AppStreamClient.associateApplicationToEntitlement(crossinline block: AssociateApplicationToEntitlementRequest.Builder.() -> Unit): AssociateApplicationToEntitlementResponse = associateApplicationToEntitlement(AssociateApplicationToEntitlementRequest.Builder().apply(block).build())

/**
 * Associates the specified fleet with the specified stack.
 */
public suspend inline fun AppStreamClient.associateFleet(crossinline block: AssociateFleetRequest.Builder.() -> Unit): AssociateFleetResponse = associateFleet(AssociateFleetRequest.Builder().apply(block).build())

/**
 * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.
 */
public suspend inline fun AppStreamClient.batchAssociateUserStack(crossinline block: BatchAssociateUserStackRequest.Builder.() -> Unit): BatchAssociateUserStackResponse = batchAssociateUserStack(BatchAssociateUserStackRequest.Builder().apply(block).build())

/**
 * Disassociates the specified users from the specified stacks.
 */
public suspend inline fun AppStreamClient.batchDisassociateUserStack(crossinline block: BatchDisassociateUserStackRequest.Builder.() -> Unit): BatchDisassociateUserStackResponse = batchDisassociateUserStack(BatchDisassociateUserStackRequest.Builder().apply(block).build())

/**
 * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.
 */
public suspend inline fun AppStreamClient.copyImage(crossinline block: CopyImageRequest.Builder.() -> Unit): CopyImageResponse = copyImage(CopyImageRequest.Builder().apply(block).build())

/**
 * Creates an app block.
 *
 * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes the application binaries and other files necessary to launch your applications. Multiple applications can be assigned to a single app block.
 *
 * This is only supported for Elastic fleets.
 */
public suspend inline fun AppStreamClient.createAppBlock(crossinline block: CreateAppBlockRequest.Builder.() -> Unit): CreateAppBlockResponse = createAppBlock(CreateAppBlockRequest.Builder().apply(block).build())

/**
 * Creates an app block builder.
 */
public suspend inline fun AppStreamClient.createAppBlockBuilder(crossinline block: CreateAppBlockBuilderRequest.Builder.() -> Unit): CreateAppBlockBuilderResponse = createAppBlockBuilder(CreateAppBlockBuilderRequest.Builder().apply(block).build())

/**
 * Creates a URL to start a create app block builder streaming session.
 */
public suspend inline fun AppStreamClient.createAppBlockBuilderStreamingUrl(crossinline block: CreateAppBlockBuilderStreamingUrlRequest.Builder.() -> Unit): CreateAppBlockBuilderStreamingUrlResponse = createAppBlockBuilderStreamingUrl(CreateAppBlockBuilderStreamingUrlRequest.Builder().apply(block).build())

/**
 * Creates an application.
 *
 * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on Elastic fleet streaming instances. An application consists of the launch details, icon, and display name. Applications are associated with an app block that contains the application binaries and other files. The applications assigned to an Elastic fleet are the applications users can launch.
 *
 * This is only supported for Elastic fleets.
 */
public suspend inline fun AppStreamClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
 */
public suspend inline fun AppStreamClient.createDirectoryConfig(crossinline block: CreateDirectoryConfigRequest.Builder.() -> Unit): CreateDirectoryConfigResponse = createDirectoryConfig(CreateDirectoryConfigRequest.Builder().apply(block).build())

/**
 * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
 */
public suspend inline fun AppStreamClient.createEntitlement(crossinline block: CreateEntitlementRequest.Builder.() -> Unit): CreateEntitlementResponse = createEntitlement(CreateEntitlementRequest.Builder().apply(block).build())

/**
 * Creates a fleet. A fleet consists of streaming instances that your users access for their applications and desktops.
 */
public suspend inline fun AppStreamClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Creates an image builder. An image builder is a virtual machine that is used to create an image.
 *
 * The initial state of the builder is `PENDING`. When it is ready, the state is `RUNNING`.
 */
public suspend inline fun AppStreamClient.createImageBuilder(crossinline block: CreateImageBuilderRequest.Builder.() -> Unit): CreateImageBuilderResponse = createImageBuilder(CreateImageBuilderRequest.Builder().apply(block).build())

/**
 * Creates a URL to start an image builder streaming session.
 */
public suspend inline fun AppStreamClient.createImageBuilderStreamingUrl(crossinline block: CreateImageBuilderStreamingUrlRequest.Builder.() -> Unit): CreateImageBuilderStreamingUrlResponse = createImageBuilderStreamingUrl(CreateImageBuilderStreamingUrlRequest.Builder().apply(block).build())

/**
 * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.
 */
public suspend inline fun AppStreamClient.createStack(crossinline block: CreateStackRequest.Builder.() -> Unit): CreateStackResponse = createStack(CreateStackRequest.Builder().apply(block).build())

/**
 * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.
 */
public suspend inline fun AppStreamClient.createStreamingUrl(crossinline block: CreateStreamingUrlRequest.Builder.() -> Unit): CreateStreamingUrlResponse = createStreamingUrl(CreateStreamingUrlRequest.Builder().apply(block).build())

/**
 * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.
 *
 * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in [Administer Your AppStream 2.0 Images](https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html), in the *Amazon AppStream 2.0 Administration Guide*.
 */
public suspend inline fun AppStreamClient.createUpdatedImage(crossinline block: CreateUpdatedImageRequest.Builder.() -> Unit): CreateUpdatedImageResponse = createUpdatedImage(CreateUpdatedImageRequest.Builder().apply(block).build())

/**
 * Creates a usage report subscription. Usage reports are generated daily.
 */
public suspend inline fun AppStreamClient.createUsageReportSubscription(crossinline block: CreateUsageReportSubscriptionRequest.Builder.() -> Unit): CreateUsageReportSubscriptionResponse = createUsageReportSubscription(CreateUsageReportSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a new user in the user pool.
 */
public suspend inline fun AppStreamClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deletes an app block.
 */
public suspend inline fun AppStreamClient.deleteAppBlock(crossinline block: DeleteAppBlockRequest.Builder.() -> Unit): DeleteAppBlockResponse = deleteAppBlock(DeleteAppBlockRequest.Builder().apply(block).build())

/**
 * Deletes an app block builder.
 *
 * An app block builder can only be deleted when it has no association with an app block.
 */
public suspend inline fun AppStreamClient.deleteAppBlockBuilder(crossinline block: DeleteAppBlockBuilderRequest.Builder.() -> Unit): DeleteAppBlockBuilderResponse = deleteAppBlockBuilder(DeleteAppBlockBuilderRequest.Builder().apply(block).build())

/**
 * Deletes an application.
 */
public suspend inline fun AppStreamClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.
 */
public suspend inline fun AppStreamClient.deleteDirectoryConfig(crossinline block: DeleteDirectoryConfigRequest.Builder.() -> Unit): DeleteDirectoryConfigResponse = deleteDirectoryConfig(DeleteDirectoryConfigRequest.Builder().apply(block).build())

/**
 * Deletes the specified entitlement.
 */
public suspend inline fun AppStreamClient.deleteEntitlement(crossinline block: DeleteEntitlementRequest.Builder.() -> Unit): DeleteEntitlementResponse = deleteEntitlement(DeleteEntitlementRequest.Builder().apply(block).build())

/**
 * Deletes the specified fleet.
 */
public suspend inline fun AppStreamClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.
 */
public suspend inline fun AppStreamClient.deleteImage(crossinline block: DeleteImageRequest.Builder.() -> Unit): DeleteImageResponse = deleteImage(DeleteImageRequest.Builder().apply(block).build())

/**
 * Deletes the specified image builder and releases the capacity.
 */
public suspend inline fun AppStreamClient.deleteImageBuilder(crossinline block: DeleteImageBuilderRequest.Builder.() -> Unit): DeleteImageBuilderResponse = deleteImageBuilder(DeleteImageBuilderRequest.Builder().apply(block).build())

/**
 * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.
 */
public suspend inline fun AppStreamClient.deleteImagePermissions(crossinline block: DeleteImagePermissionsRequest.Builder.() -> Unit): DeleteImagePermissionsResponse = deleteImagePermissions(DeleteImagePermissionsRequest.Builder().apply(block).build())

/**
 * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.
 */
public suspend inline fun AppStreamClient.deleteStack(crossinline block: DeleteStackRequest.Builder.() -> Unit): DeleteStackResponse = deleteStack(DeleteStackRequest.Builder().apply(block).build())

/**
 * Disables usage report generation.
 */
public suspend inline fun AppStreamClient.deleteUsageReportSubscription(crossinline block: DeleteUsageReportSubscriptionRequest.Builder.() -> Unit): DeleteUsageReportSubscriptionResponse = deleteUsageReportSubscription(DeleteUsageReportSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes a user from the user pool.
 */
public suspend inline fun AppStreamClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more app block builder associations.
 */
public suspend inline fun AppStreamClient.describeAppBlockBuilderAppBlockAssociations(crossinline block: DescribeAppBlockBuilderAppBlockAssociationsRequest.Builder.() -> Unit): DescribeAppBlockBuilderAppBlockAssociationsResponse = describeAppBlockBuilderAppBlockAssociations(DescribeAppBlockBuilderAppBlockAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more app block builders.
 */
public suspend inline fun AppStreamClient.describeAppBlockBuilders(crossinline block: DescribeAppBlockBuildersRequest.Builder.() -> Unit): DescribeAppBlockBuildersResponse = describeAppBlockBuilders(DescribeAppBlockBuildersRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more app blocks.
 */
public suspend inline fun AppStreamClient.describeAppBlocks(crossinline block: DescribeAppBlocksRequest.Builder.() -> Unit): DescribeAppBlocksResponse = describeAppBlocks(DescribeAppBlocksRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName must be specified.
 */
public suspend inline fun AppStreamClient.describeApplicationFleetAssociations(crossinline block: DescribeApplicationFleetAssociationsRequest.Builder.() -> Unit): DescribeApplicationFleetAssociationsResponse = describeApplicationFleetAssociations(DescribeApplicationFleetAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more applications.
 */
public suspend inline fun AppStreamClient.describeApplications(crossinline block: DescribeApplicationsRequest.Builder.() -> Unit): DescribeApplicationsResponse = describeApplications(DescribeApplicationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
 *
 * Although the response syntax in this topic includes the account password, this password is not returned in the actual response.
 */
public suspend inline fun AppStreamClient.describeDirectoryConfigs(crossinline block: DescribeDirectoryConfigsRequest.Builder.() -> Unit): DescribeDirectoryConfigsResponse = describeDirectoryConfigs(DescribeDirectoryConfigsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one of more entitlements.
 */
public suspend inline fun AppStreamClient.describeEntitlements(crossinline block: DescribeEntitlementsRequest.Builder.() -> Unit): DescribeEntitlementsResponse = describeEntitlements(DescribeEntitlementsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.
 */
public suspend inline fun AppStreamClient.describeFleets(crossinline block: DescribeFleetsRequest.Builder.() -> Unit): DescribeFleetsResponse = describeFleets(DescribeFleetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.
 */
public suspend inline fun AppStreamClient.describeImageBuilders(crossinline block: DescribeImageBuildersRequest.Builder.() -> Unit): DescribeImageBuildersResponse = describeImageBuilders(DescribeImageBuildersRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
 */
public suspend inline fun AppStreamClient.describeImagePermissions(crossinline block: DescribeImagePermissionsRequest.Builder.() -> Unit): DescribeImagePermissionsResponse = describeImagePermissions(DescribeImagePermissionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.
 */
public suspend inline fun AppStreamClient.describeImages(crossinline block: DescribeImagesRequest.Builder.() -> Unit): DescribeImagesResponse = describeImages(DescribeImagesRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.
 */
public suspend inline fun AppStreamClient.describeSessions(crossinline block: DescribeSessionsRequest.Builder.() -> Unit): DescribeSessionsResponse = describeSessions(DescribeSessionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.
 */
public suspend inline fun AppStreamClient.describeStacks(crossinline block: DescribeStacksRequest.Builder.() -> Unit): DescribeStacksResponse = describeStacks(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more usage report subscriptions.
 */
public suspend inline fun AppStreamClient.describeUsageReportSubscriptions(crossinline block: DescribeUsageReportSubscriptionsRequest.Builder.() -> Unit): DescribeUsageReportSubscriptionsResponse = describeUsageReportSubscriptions(DescribeUsageReportSubscriptionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:
 * + The stack name
 * + The user name (email address of the user associated with the stack) and the authentication type for the user
 */
public suspend inline fun AppStreamClient.describeUserStackAssociations(crossinline block: DescribeUserStackAssociationsRequest.Builder.() -> Unit): DescribeUserStackAssociationsResponse = describeUserStackAssociations(DescribeUserStackAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified users in the user pool.
 */
public suspend inline fun AppStreamClient.describeUsers(crossinline block: DescribeUsersRequest.Builder.() -> Unit): DescribeUsersResponse = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

/**
 * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user.
 */
public suspend inline fun AppStreamClient.disableUser(crossinline block: DisableUserRequest.Builder.() -> Unit): DisableUserResponse = disableUser(DisableUserRequest.Builder().apply(block).build())

/**
 * Disassociates a specified app block builder from a specified app block.
 */
public suspend inline fun AppStreamClient.disassociateAppBlockBuilderAppBlock(crossinline block: DisassociateAppBlockBuilderAppBlockRequest.Builder.() -> Unit): DisassociateAppBlockBuilderAppBlockResponse = disassociateAppBlockBuilderAppBlock(DisassociateAppBlockBuilderAppBlockRequest.Builder().apply(block).build())

/**
 * Disassociates the specified application from the fleet.
 */
public suspend inline fun AppStreamClient.disassociateApplicationFleet(crossinline block: DisassociateApplicationFleetRequest.Builder.() -> Unit): DisassociateApplicationFleetResponse = disassociateApplicationFleet(DisassociateApplicationFleetRequest.Builder().apply(block).build())

/**
 * Deletes the specified application from the specified entitlement.
 */
public suspend inline fun AppStreamClient.disassociateApplicationFromEntitlement(crossinline block: DisassociateApplicationFromEntitlementRequest.Builder.() -> Unit): DisassociateApplicationFromEntitlementResponse = disassociateApplicationFromEntitlement(DisassociateApplicationFromEntitlementRequest.Builder().apply(block).build())

/**
 * Disassociates the specified fleet from the specified stack.
 */
public suspend inline fun AppStreamClient.disassociateFleet(crossinline block: DisassociateFleetRequest.Builder.() -> Unit): DisassociateFleetResponse = disassociateFleet(DisassociateFleetRequest.Builder().apply(block).build())

/**
 * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.
 */
public suspend inline fun AppStreamClient.enableUser(crossinline block: EnableUserRequest.Builder.() -> Unit): EnableUserResponse = enableUser(EnableUserRequest.Builder().apply(block).build())

/**
 * Immediately stops the specified streaming session.
 */
public suspend inline fun AppStreamClient.expireSession(crossinline block: ExpireSessionRequest.Builder.() -> Unit): ExpireSessionResponse = expireSession(ExpireSessionRequest.Builder().apply(block).build())

/**
 * Retrieves the name of the fleet that is associated with the specified stack.
 */
public suspend inline fun AppStreamClient.listAssociatedFleets(crossinline block: ListAssociatedFleetsRequest.Builder.() -> Unit): ListAssociatedFleetsResponse = listAssociatedFleets(ListAssociatedFleetsRequest.Builder().apply(block).build())

/**
 * Retrieves the name of the stack with which the specified fleet is associated.
 */
public suspend inline fun AppStreamClient.listAssociatedStacks(crossinline block: ListAssociatedStacksRequest.Builder.() -> Unit): ListAssociatedStacksResponse = listAssociatedStacks(ListAssociatedStacksRequest.Builder().apply(block).build())

/**
 * Retrieves a list of entitled applications.
 */
public suspend inline fun AppStreamClient.listEntitledApplications(crossinline block: ListEntitledApplicationsRequest.Builder.() -> Unit): ListEntitledApplicationsResponse = listEntitledApplications(ListEntitledApplicationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
 *
 * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
 */
public suspend inline fun AppStreamClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts an app block builder.
 *
 * An app block builder can only be started when it's associated with an app block.
 *
 * Starting an app block builder starts a new instance, which is equivalent to an elastic fleet instance with application builder assistance functionality.
 */
public suspend inline fun AppStreamClient.startAppBlockBuilder(crossinline block: StartAppBlockBuilderRequest.Builder.() -> Unit): StartAppBlockBuilderResponse = startAppBlockBuilder(StartAppBlockBuilderRequest.Builder().apply(block).build())

/**
 * Starts the specified fleet.
 */
public suspend inline fun AppStreamClient.startFleet(crossinline block: StartFleetRequest.Builder.() -> Unit): StartFleetResponse = startFleet(StartFleetRequest.Builder().apply(block).build())

/**
 * Starts the specified image builder.
 */
public suspend inline fun AppStreamClient.startImageBuilder(crossinline block: StartImageBuilderRequest.Builder.() -> Unit): StartImageBuilderResponse = startImageBuilder(StartImageBuilderRequest.Builder().apply(block).build())

/**
 * Stops an app block builder.
 *
 * Stopping an app block builder terminates the instance, and the instance state is not persisted.
 */
public suspend inline fun AppStreamClient.stopAppBlockBuilder(crossinline block: StopAppBlockBuilderRequest.Builder.() -> Unit): StopAppBlockBuilderResponse = stopAppBlockBuilder(StopAppBlockBuilderRequest.Builder().apply(block).build())

/**
 * Stops the specified fleet.
 */
public suspend inline fun AppStreamClient.stopFleet(crossinline block: StopFleetRequest.Builder.() -> Unit): StopFleetResponse = stopFleet(StopFleetRequest.Builder().apply(block).build())

/**
 * Stops the specified image builder.
 */
public suspend inline fun AppStreamClient.stopImageBuilder(crossinline block: StopImageBuilderRequest.Builder.() -> Unit): StopImageBuilderResponse = stopImageBuilder(StopImageBuilderRequest.Builder().apply(block).build())

/**
 * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
 *
 * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
 *
 * To list the current tags for your resources, use ListTagsForResource. To disassociate tags from your resources, use UntagResource.
 *
 * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
 */
public suspend inline fun AppStreamClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
 *
 * To list the current tags for your resources, use ListTagsForResource.
 *
 * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
 */
public suspend inline fun AppStreamClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an app block builder.
 *
 * If the app block builder is in the `STARTING` or `STOPPING` state, you can't update it. If the app block builder is in the `RUNNING` state, you can only update the DisplayName and Description. If the app block builder is in the `STOPPED` state, you can update any attribute except the Name.
 */
public suspend inline fun AppStreamClient.updateAppBlockBuilder(crossinline block: UpdateAppBlockBuilderRequest.Builder.() -> Unit): UpdateAppBlockBuilderResponse = updateAppBlockBuilder(UpdateAppBlockBuilderRequest.Builder().apply(block).build())

/**
 * Updates the specified application.
 */
public suspend inline fun AppStreamClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
 */
public suspend inline fun AppStreamClient.updateDirectoryConfig(crossinline block: UpdateDirectoryConfigRequest.Builder.() -> Unit): UpdateDirectoryConfigResponse = updateDirectoryConfig(UpdateDirectoryConfigRequest.Builder().apply(block).build())

/**
 * Updates the specified entitlement.
 */
public suspend inline fun AppStreamClient.updateEntitlement(crossinline block: UpdateEntitlementRequest.Builder.() -> Unit): UpdateEntitlementResponse = updateEntitlement(UpdateEntitlementRequest.Builder().apply(block).build())

/**
 * Updates the specified fleet.
 *
 * If the fleet is in the `STOPPED` state, you can update any attribute except the fleet name.
 *
 * If the fleet is in the `RUNNING` state, you can update the following based on the fleet type:
 * + Always-On and On-Demand fleet typesYou can update the `DisplayName`, `ComputeCapacity`, `ImageARN`, `ImageName`, `IdleDisconnectTimeoutInSeconds`, and `DisconnectTimeoutInSeconds` attributes.
 * + Elastic fleet typeYou can update the `DisplayName`, `IdleDisconnectTimeoutInSeconds`, `DisconnectTimeoutInSeconds`, `MaxConcurrentSessions`, `SessionScriptS3Location` and `UsbDeviceFilterStrings` attributes.
 *
 * If the fleet is in the `STARTING` or `STOPPED` state, you can't update it.
 */
public suspend inline fun AppStreamClient.updateFleet(crossinline block: UpdateFleetRequest.Builder.() -> Unit): UpdateFleetResponse = updateFleet(UpdateFleetRequest.Builder().apply(block).build())

/**
 * Adds or updates permissions for the specified private image.
 */
public suspend inline fun AppStreamClient.updateImagePermissions(crossinline block: UpdateImagePermissionsRequest.Builder.() -> Unit): UpdateImagePermissionsResponse = updateImagePermissions(UpdateImagePermissionsRequest.Builder().apply(block).build())

/**
 * Updates the specified fields for the specified stack.
 */
public suspend inline fun AppStreamClient.updateStack(crossinline block: UpdateStackRequest.Builder.() -> Unit): UpdateStackResponse = updateStack(UpdateStackRequest.Builder().apply(block).build())
