// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.serde

import aws.sdk.kotlin.services.apprunner.model.AppRunnerException
import aws.sdk.kotlin.services.apprunner.model.UpdateVpcIngressConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.VpcIngressConnection
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateVpcIngressConnectionOperationDeserializer: HttpDeserialize<UpdateVpcIngressConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateVpcIngressConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateVpcIngressConnectionError(context, call)
        }
        val builder = UpdateVpcIngressConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateVpcIngressConnectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateVpcIngressConnectionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppRunnerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppRunnerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateVpcIngressConnectionOperationBody(builder: UpdateVpcIngressConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VPCINGRESSCONNECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcIngressConnection"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VPCINGRESSCONNECTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VPCINGRESSCONNECTION_DESCRIPTOR.index -> builder.vpcIngressConnection = deserializeVpcIngressConnectionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
