// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.serde

import aws.sdk.kotlin.services.apprunner.model.AppRunnerException
import aws.sdk.kotlin.services.apprunner.model.CustomDomain
import aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse
import aws.sdk.kotlin.services.apprunner.model.VpcDnsTarget
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeCustomDomainsOperationDeserializer: HttpDeserialize<DescribeCustomDomainsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeCustomDomainsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCustomDomainsError(context, call)
        }
        val builder = DescribeCustomDomainsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCustomDomainsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeCustomDomainsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppRunnerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppRunnerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCustomDomainsOperationBody(builder: DescribeCustomDomainsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMDOMAINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CustomDomains"))
    val DNSTARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DNSTarget"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceArn"))
    val VPCDNSTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("VpcDNSTargets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMDOMAINS_DESCRIPTOR)
        field(DNSTARGET_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVICEARN_DESCRIPTOR)
        field(VPCDNSTARGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMDOMAINS_DESCRIPTOR.index -> builder.customDomains =
                    deserializer.deserializeList(CUSTOMDOMAINS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomDomain>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomDomainDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DNSTARGET_DESCRIPTOR.index -> builder.dnsTarget = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVICEARN_DESCRIPTOR.index -> builder.serviceArn = deserializeString()
                VPCDNSTARGETS_DESCRIPTOR.index -> builder.vpcDnsTargets =
                    deserializer.deserializeList(VPCDNSTARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcDnsTarget>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcDnsTargetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
