// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.paginators

import aws.sdk.kotlin.services.apprunner.AppRunnerClient
import aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse
import aws.sdk.kotlin.services.apprunner.model.ListAutoScalingConfigurationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListAutoScalingConfigurationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListConnectionsRequest
import aws.sdk.kotlin.services.apprunner.model.ListConnectionsResponse
import aws.sdk.kotlin.services.apprunner.model.ListObservabilityConfigurationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListObservabilityConfigurationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListOperationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListOperationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.ListServicesRequest
import aws.sdk.kotlin.services.apprunner.model.ListServicesResponse
import aws.sdk.kotlin.services.apprunner.model.ListVpcConnectorsRequest
import aws.sdk.kotlin.services.apprunner.model.ListVpcConnectorsResponse
import aws.sdk.kotlin.services.apprunner.model.ListVpcIngressConnectionsRequest
import aws.sdk.kotlin.services.apprunner.model.ListVpcIngressConnectionsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeCustomDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCustomDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCustomDomainsResponse]
 */
public fun AppRunnerClient.describeCustomDomainsPaginated(initialRequest: DescribeCustomDomainsRequest): Flow<DescribeCustomDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCustomDomainsPaginated.describeCustomDomains(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCustomDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCustomDomainsResponse]
 */
public fun AppRunnerClient.describeCustomDomainsPaginated(block: DescribeCustomDomainsRequest.Builder.() -> Unit): Flow<DescribeCustomDomainsResponse> =
    describeCustomDomainsPaginated(DescribeCustomDomainsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAutoScalingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAutoScalingConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAutoScalingConfigurationsResponse]
 */
public fun AppRunnerClient.listAutoScalingConfigurationsPaginated(initialRequest: ListAutoScalingConfigurationsRequest = ListAutoScalingConfigurationsRequest { }): Flow<ListAutoScalingConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAutoScalingConfigurationsPaginated.listAutoScalingConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAutoScalingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAutoScalingConfigurationsResponse]
 */
public fun AppRunnerClient.listAutoScalingConfigurationsPaginated(block: ListAutoScalingConfigurationsRequest.Builder.() -> Unit): Flow<ListAutoScalingConfigurationsResponse> =
    listAutoScalingConfigurationsPaginated(ListAutoScalingConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectionsResponse]
 */
public fun AppRunnerClient.listConnectionsPaginated(initialRequest: ListConnectionsRequest = ListConnectionsRequest { }): Flow<ListConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectionsPaginated.listConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectionsResponse]
 */
public fun AppRunnerClient.listConnectionsPaginated(block: ListConnectionsRequest.Builder.() -> Unit): Flow<ListConnectionsResponse> =
    listConnectionsPaginated(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListObservabilityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObservabilityConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObservabilityConfigurationsResponse]
 */
public fun AppRunnerClient.listObservabilityConfigurationsPaginated(initialRequest: ListObservabilityConfigurationsRequest = ListObservabilityConfigurationsRequest { }): Flow<ListObservabilityConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listObservabilityConfigurationsPaginated.listObservabilityConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListObservabilityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObservabilityConfigurationsResponse]
 */
public fun AppRunnerClient.listObservabilityConfigurationsPaginated(block: ListObservabilityConfigurationsRequest.Builder.() -> Unit): Flow<ListObservabilityConfigurationsResponse> =
    listObservabilityConfigurationsPaginated(ListObservabilityConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun AppRunnerClient.listOperationsPaginated(initialRequest: ListOperationsRequest): Flow<ListOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOperationsPaginated.listOperations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun AppRunnerClient.listOperationsPaginated(block: ListOperationsRequest.Builder.() -> Unit): Flow<ListOperationsResponse> =
    listOperationsPaginated(ListOperationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun AppRunnerClient.listServicesPaginated(initialRequest: ListServicesRequest = ListServicesRequest { }): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun AppRunnerClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServicesForAutoScalingConfigurationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesForAutoScalingConfigurationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesForAutoScalingConfigurationResponse]
 */
public fun AppRunnerClient.listServicesForAutoScalingConfigurationPaginated(initialRequest: ListServicesForAutoScalingConfigurationRequest): Flow<ListServicesForAutoScalingConfigurationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesForAutoScalingConfigurationPaginated.listServicesForAutoScalingConfiguration(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesForAutoScalingConfigurationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesForAutoScalingConfigurationResponse]
 */
public fun AppRunnerClient.listServicesForAutoScalingConfigurationPaginated(block: ListServicesForAutoScalingConfigurationRequest.Builder.() -> Unit): Flow<ListServicesForAutoScalingConfigurationResponse> =
    listServicesForAutoScalingConfigurationPaginated(ListServicesForAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVpcConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVpcConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcConnectorsResponse]
 */
public fun AppRunnerClient.listVpcConnectorsPaginated(initialRequest: ListVpcConnectorsRequest = ListVpcConnectorsRequest { }): Flow<ListVpcConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVpcConnectorsPaginated.listVpcConnectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVpcConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcConnectorsResponse]
 */
public fun AppRunnerClient.listVpcConnectorsPaginated(block: ListVpcConnectorsRequest.Builder.() -> Unit): Flow<ListVpcConnectorsResponse> =
    listVpcConnectorsPaginated(ListVpcConnectorsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVpcIngressConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVpcIngressConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcIngressConnectionsResponse]
 */
public fun AppRunnerClient.listVpcIngressConnectionsPaginated(initialRequest: ListVpcIngressConnectionsRequest = ListVpcIngressConnectionsRequest { }): Flow<ListVpcIngressConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVpcIngressConnectionsPaginated.listVpcIngressConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVpcIngressConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcIngressConnectionsResponse]
 */
public fun AppRunnerClient.listVpcIngressConnectionsPaginated(block: ListVpcIngressConnectionsRequest.Builder.() -> Unit): Flow<ListVpcIngressConnectionsResponse> =
    listVpcIngressConnectionsPaginated(ListVpcIngressConnectionsRequest.Builder().apply(block).build())
