// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The App Runner resource that specifies an App Runner endpoint for incoming traffic. It establishes a connection between a VPC interface endpoint and a App Runner service, to make your App Runner service accessible from only within an Amazon VPC.
 */
public class VpcIngressConnection private constructor(builder: Builder) {
    /**
     * The Account Id you use to create the VPC Ingress Connection resource.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.
     * +  Type: Timestamp
     * +  Required: Yes
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The time when the App Runner service was deleted. It's in the Unix time stamp format.
     * +  Type: Timestamp
     * +  Required: No
     */
    public val deletedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedAt
    /**
     * The domain name associated with the VPC Ingress Connection resource.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate with the VPC Ingress Connection resource.
     */
    public val ingressVpcConfiguration: aws.sdk.kotlin.services.apprunner.model.IngressVpcConfiguration? = builder.ingressVpcConfiguration
    /**
     * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following statuses: `AVAILABLE`, `PENDING_CREATION`, `PENDING_UPDATE`, `PENDING_DELETION`,`FAILED_CREATION`, `FAILED_UPDATE`, `FAILED_DELETION`, and `DELETED`..
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.VpcIngressConnectionStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     */
    public val vpcIngressConnectionArn: kotlin.String? = builder.vpcIngressConnectionArn
    /**
     * The customer-provided VPC Ingress Connection name.
     */
    public val vpcIngressConnectionName: kotlin.String? = builder.vpcIngressConnectionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.VpcIngressConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcIngressConnection(")
        append("accountId=$accountId,")
        append("createdAt=$createdAt,")
        append("deletedAt=$deletedAt,")
        append("domainName=$domainName,")
        append("ingressVpcConfiguration=$ingressVpcConfiguration,")
        append("serviceArn=$serviceArn,")
        append("status=$status,")
        append("vpcIngressConnectionArn=$vpcIngressConnectionArn,")
        append("vpcIngressConnectionName=$vpcIngressConnectionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deletedAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (ingressVpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcIngressConnectionArn?.hashCode() ?: 0)
        result = 31 * result + (vpcIngressConnectionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcIngressConnection

        if (accountId != other.accountId) return false
        if (createdAt != other.createdAt) return false
        if (deletedAt != other.deletedAt) return false
        if (domainName != other.domainName) return false
        if (ingressVpcConfiguration != other.ingressVpcConfiguration) return false
        if (serviceArn != other.serviceArn) return false
        if (status != other.status) return false
        if (vpcIngressConnectionArn != other.vpcIngressConnectionArn) return false
        if (vpcIngressConnectionName != other.vpcIngressConnectionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.VpcIngressConnection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Account Id you use to create the VPC Ingress Connection resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * The time when the VPC Ingress Connection was created. It's in the Unix time stamp format.
         * +  Type: Timestamp
         * +  Required: Yes
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the App Runner service was deleted. It's in the Unix time stamp format.
         * +  Type: Timestamp
         * +  Required: No
         */
        public var deletedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain name associated with the VPC Ingress Connection resource.
         */
        public var domainName: kotlin.String? = null
        /**
         * Specifications for the customer’s VPC and related PrivateLink VPC endpoint that are used to associate with the VPC Ingress Connection resource.
         */
        public var ingressVpcConfiguration: aws.sdk.kotlin.services.apprunner.model.IngressVpcConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the service associated with the VPC Ingress Connection.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * The current status of the VPC Ingress Connection. The VPC Ingress Connection displays one of the following statuses: `AVAILABLE`, `PENDING_CREATION`, `PENDING_UPDATE`, `PENDING_DELETION`,`FAILED_CREATION`, `FAILED_UPDATE`, `FAILED_DELETION`, and `DELETED`..
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.VpcIngressConnectionStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
         */
        public var vpcIngressConnectionArn: kotlin.String? = null
        /**
         * The customer-provided VPC Ingress Connection name.
         */
        public var vpcIngressConnectionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.VpcIngressConnection) : this() {
            this.accountId = x.accountId
            this.createdAt = x.createdAt
            this.deletedAt = x.deletedAt
            this.domainName = x.domainName
            this.ingressVpcConfiguration = x.ingressVpcConfiguration
            this.serviceArn = x.serviceArn
            this.status = x.status
            this.vpcIngressConnectionArn = x.vpcIngressConnectionArn
            this.vpcIngressConnectionName = x.vpcIngressConnectionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.VpcIngressConnection = VpcIngressConnection(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.IngressVpcConfiguration] inside the given [block]
         */
        public fun ingressVpcConfiguration(block: aws.sdk.kotlin.services.apprunner.model.IngressVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.ingressVpcConfiguration = aws.sdk.kotlin.services.apprunner.model.IngressVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
