// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an App Runner VPC connector resource. A VPC connector describes the Amazon Virtual Private Cloud (Amazon VPC) that an App Runner service is associated with, and the subnets and security group that are used.
 *
 * Multiple revisions of a connector might have the same `Name` and different `Revision` values.
 *
 * At this time, App Runner supports only one revision per name.
 */
public class VpcConnector private constructor(builder: Builder) {
    /**
     * The time when the VPC connector was created. It's in Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The time when the VPC connector was deleted. It's in Unix time stamp format.
     */
    public val deletedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedAt
    /**
     * A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The current state of the VPC connector. If the status of a connector revision is `INACTIVE`, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.VpcConnectorStatus? = builder.status
    /**
     * A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The Amazon Resource Name (ARN) of this VPC connector.
     */
    public val vpcConnectorArn: kotlin.String? = builder.vpcConnectorArn
    /**
     * The customer-provided VPC connector name.
     */
    public val vpcConnectorName: kotlin.String? = builder.vpcConnectorName
    /**
     * The revision of this VPC connector. It's unique among all the active connectors (`"Status": "ACTIVE"`) that share the same `Name`.
     *
     * At this time, App Runner supports only one revision per name.
     */
    public val vpcConnectorRevision: kotlin.Int = builder.vpcConnectorRevision

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.VpcConnector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConnector(")
        append("createdAt=$createdAt,")
        append("deletedAt=$deletedAt,")
        append("securityGroups=$securityGroups,")
        append("status=$status,")
        append("subnets=$subnets,")
        append("vpcConnectorArn=$vpcConnectorArn,")
        append("vpcConnectorName=$vpcConnectorName,")
        append("vpcConnectorRevision=$vpcConnectorRevision")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (deletedAt?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectorArn?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectorName?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectorRevision)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConnector

        if (createdAt != other.createdAt) return false
        if (deletedAt != other.deletedAt) return false
        if (securityGroups != other.securityGroups) return false
        if (status != other.status) return false
        if (subnets != other.subnets) return false
        if (vpcConnectorArn != other.vpcConnectorArn) return false
        if (vpcConnectorName != other.vpcConnectorName) return false
        if (vpcConnectorRevision != other.vpcConnectorRevision) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.VpcConnector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the VPC connector was created. It's in Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the VPC connector was deleted. It's in Unix time stamp format.
         */
        public var deletedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
         */
        public var securityGroups: List<String>? = null
        /**
         * The current state of the VPC connector. If the status of a connector revision is `INACTIVE`, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.VpcConnectorStatus? = null
        /**
         * A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.
         */
        public var subnets: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of this VPC connector.
         */
        public var vpcConnectorArn: kotlin.String? = null
        /**
         * The customer-provided VPC connector name.
         */
        public var vpcConnectorName: kotlin.String? = null
        /**
         * The revision of this VPC connector. It's unique among all the active connectors (`"Status": "ACTIVE"`) that share the same `Name`.
         *
         * At this time, App Runner supports only one revision per name.
         */
        public var vpcConnectorRevision: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.VpcConnector) : this() {
            this.createdAt = x.createdAt
            this.deletedAt = x.deletedAt
            this.securityGroups = x.securityGroups
            this.status = x.status
            this.subnets = x.subnets
            this.vpcConnectorArn = x.vpcConnectorArn
            this.vpcConnectorName = x.vpcConnectorName
            this.vpcConnectorRevision = x.vpcConnectorRevision
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.VpcConnector = VpcConnector(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
