// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class UpdateServiceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with the App Runner service.
     */
    public val autoScalingConfigurationArn: kotlin.String? = builder.autoScalingConfigurationArn
    /**
     * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
     */
    public val healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = builder.healthCheckConfiguration
    /**
     * The runtime configuration to apply to instances (scaling units) of your service.
     */
    public val instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The observability configuration of your service.
     */
    public val observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = builder.observabilityConfiguration
    /**
     * The Amazon Resource Name (ARN) of the App Runner service that you want to update.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * The source configuration to apply to the App Runner service.
     *
     * You can change the configuration of the code or image repository that the service uses. However, you can't switch from code to image or the other way around. This means that you must provide the same structure member of `SourceConfiguration` that you originally included when you created the service. Specifically, you can include either `CodeRepository` or `ImageRepository`. To update the source configuration, set the values to members of the structure that you include.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = builder.sourceConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.UpdateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServiceRequest(")
        append("autoScalingConfigurationArn=$autoScalingConfigurationArn,")
        append("healthCheckConfiguration=$healthCheckConfiguration,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("networkConfiguration=$networkConfiguration,")
        append("observabilityConfiguration=$observabilityConfiguration,")
        append("serviceArn=$serviceArn,")
        append("sourceConfiguration=$sourceConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (healthCheckConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServiceRequest

        if (autoScalingConfigurationArn != other.autoScalingConfigurationArn) return false
        if (healthCheckConfiguration != other.healthCheckConfiguration) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (observabilityConfiguration != other.observabilityConfiguration) return false
        if (serviceArn != other.serviceArn) return false
        if (sourceConfiguration != other.sourceConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.UpdateServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with the App Runner service.
         */
        public var autoScalingConfigurationArn: kotlin.String? = null
        /**
         * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
         */
        public var healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = null
        /**
         * The runtime configuration to apply to instances (scaling units) of your service.
         */
        public var instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = null
        /**
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = null
        /**
         * The observability configuration of your service.
         */
        public var observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the App Runner service that you want to update.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * The source configuration to apply to the App Runner service.
         *
         * You can change the configuration of the code or image repository that the service uses. However, you can't switch from code to image or the other way around. This means that you must provide the same structure member of `SourceConfiguration` that you originally included when you created the service. Specifically, you can include either `CodeRepository` or `ImageRepository`. To update the source configuration, set the values to members of the structure that you include.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.UpdateServiceRequest) : this() {
            this.autoScalingConfigurationArn = x.autoScalingConfigurationArn
            this.healthCheckConfiguration = x.healthCheckConfiguration
            this.instanceConfiguration = x.instanceConfiguration
            this.networkConfiguration = x.networkConfiguration
            this.observabilityConfiguration = x.observabilityConfiguration
            this.serviceArn = x.serviceArn
            this.sourceConfiguration = x.sourceConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.UpdateServiceRequest = UpdateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration] inside the given [block]
         */
        public fun healthCheckConfiguration(block: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.Builder.() -> kotlin.Unit) {
            this.healthCheckConfiguration = aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration] inside the given [block]
         */
        public fun instanceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceConfiguration = aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration] inside the given [block]
         */
        public fun observabilityConfiguration(block: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.Builder.() -> kotlin.Unit) {
            this.observabilityConfiguration = aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.SourceConfiguration] inside the given [block]
         */
        public fun sourceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.Builder.() -> kotlin.Unit) {
            this.sourceConfiguration = aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
