// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the source deployed to an App Runner service. It can be a code or an image repository.
 */
public class SourceConfiguration private constructor(builder: Builder) {
    /**
     * Describes the resources that are needed to authenticate access to some source repositories.
     */
    public val authenticationConfiguration: aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration? = builder.authenticationConfiguration
    /**
     * If `true`, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.
     *
     * Default: App Runner sets to `false` for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to `true` in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
     */
    public val autoDeploymentsEnabled: kotlin.Boolean? = builder.autoDeploymentsEnabled
    /**
     * The description of a source code repository.
     *
     * You must provide either this member or `ImageRepository` (but not both).
     */
    public val codeRepository: aws.sdk.kotlin.services.apprunner.model.CodeRepository? = builder.codeRepository
    /**
     * The description of a source image repository.
     *
     * You must provide either this member or `CodeRepository` (but not both).
     */
    public val imageRepository: aws.sdk.kotlin.services.apprunner.model.ImageRepository? = builder.imageRepository

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.SourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceConfiguration(")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("autoDeploymentsEnabled=$autoDeploymentsEnabled,")
        append("codeRepository=$codeRepository,")
        append("imageRepository=$imageRepository")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfiguration?.hashCode() ?: 0
        result = 31 * result + (autoDeploymentsEnabled?.hashCode() ?: 0)
        result = 31 * result + (codeRepository?.hashCode() ?: 0)
        result = 31 * result + (imageRepository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceConfiguration

        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (autoDeploymentsEnabled != other.autoDeploymentsEnabled) return false
        if (codeRepository != other.codeRepository) return false
        if (imageRepository != other.imageRepository) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.SourceConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the resources that are needed to authenticate access to some source repositories.
         */
        public var authenticationConfiguration: aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration? = null
        /**
         * If `true`, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.
         *
         * Default: App Runner sets to `false` for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to `true` in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
         */
        public var autoDeploymentsEnabled: kotlin.Boolean? = null
        /**
         * The description of a source code repository.
         *
         * You must provide either this member or `ImageRepository` (but not both).
         */
        public var codeRepository: aws.sdk.kotlin.services.apprunner.model.CodeRepository? = null
        /**
         * The description of a source image repository.
         *
         * You must provide either this member or `CodeRepository` (but not both).
         */
        public var imageRepository: aws.sdk.kotlin.services.apprunner.model.ImageRepository? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration) : this() {
            this.authenticationConfiguration = x.authenticationConfiguration
            this.autoDeploymentsEnabled = x.autoDeploymentsEnabled
            this.codeRepository = x.codeRepository
            this.imageRepository = x.imageRepository
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.SourceConfiguration = SourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration] inside the given [block]
         */
        public fun authenticationConfiguration(block: aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.authenticationConfiguration = aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.CodeRepository] inside the given [block]
         */
        public fun codeRepository(block: aws.sdk.kotlin.services.apprunner.model.CodeRepository.Builder.() -> kotlin.Unit) {
            this.codeRepository = aws.sdk.kotlin.services.apprunner.model.CodeRepository.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.ImageRepository] inside the given [block]
         */
        public fun imageRepository(block: aws.sdk.kotlin.services.apprunner.model.ImageRepository.Builder.() -> kotlin.Unit) {
            this.imageRepository = aws.sdk.kotlin.services.apprunner.model.ImageRepository.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
