// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Identifies a version of code that App Runner refers to within a source code repository.
 */
public class SourceCodeVersion private constructor(builder: Builder) {
    /**
     * The type of version identifier.
     *
     * For a git-based repository, branches represent versions.
     */
    public val type: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersionType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * A source code version.
     *
     * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceCodeVersion(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceCodeVersion

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of version identifier.
         *
         * For a git-based repository, branches represent versions.
         */
        public var type: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersionType? = null
        /**
         * A source code version.
         *
         * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion = SourceCodeVersion(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = SourceCodeVersionType.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
