// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for an App Runner service.
 *
 * This type contains limited information about a service. It doesn't include configuration details. It's returned by the [ListServices](https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html) action. Complete service information is returned by the [CreateService](https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html), [DescribeService](https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html), and [DeleteService](https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html) actions using the [Service](https://docs.aws.amazon.com/apprunner/latest/api/API_Service.html) type.
 */
public class ServiceSummary private constructor(builder: Builder) {
    /**
     * The time when the App Runner service was created. It's in the Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of this service.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
     */
    public val serviceId: kotlin.String? = builder.serviceId
    /**
     * The customer-provided service name.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     */
    public val serviceUrl: kotlin.String? = builder.serviceUrl
    /**
     * The current state of the App Runner service. These particular values mean the following.
     * + `CREATE_FAILED` – The service failed to create. The failed service isn't usable, and still counts towards your service quota. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and rebuild your service using `UpdateService`.
     * + `DELETE_FAILED` – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.ServiceStatus? = builder.status
    /**
     * The time when the App Runner service was last updated. It's in theUnix time stamp format.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ServiceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceSummary(")
        append("createdAt=$createdAt,")
        append("serviceArn=$serviceArn,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceUrl=$serviceUrl,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceSummary

        if (createdAt != other.createdAt) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceUrl != other.serviceUrl) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ServiceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the App Runner service was created. It's in the Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of this service.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The customer-provided service name.
         */
        public var serviceName: kotlin.String? = null
        /**
         * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
         */
        public var serviceUrl: kotlin.String? = null
        /**
         * The current state of the App Runner service. These particular values mean the following.
         * + `CREATE_FAILED` – The service failed to create. The failed service isn't usable, and still counts towards your service quota. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and rebuild your service using `UpdateService`.
         * + `DELETE_FAILED` – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.ServiceStatus? = null
        /**
         * The time when the App Runner service was last updated. It's in theUnix time stamp format.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ServiceSummary) : this() {
            this.createdAt = x.createdAt
            this.serviceArn = x.serviceArn
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceUrl = x.serviceUrl
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ServiceSummary = ServiceSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
