// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the observability configuration of an App Runner service. These are additional observability features, like tracing, that you choose to enable. They're configured in a separate resource that you associate with your service.
 */
public class ServiceObservabilityConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the observability configuration that is associated with the service. Specified only when `ObservabilityEnabled` is `true`.
     *
     * Specify an ARN with a name and a revision number to associate that revision. For example: `arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3`
     *
     * Specify just the name to associate the latest revision. For example: `arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing`
     */
    public val observabilityConfigurationArn: kotlin.String? = builder.observabilityConfigurationArn
    /**
     * When `true`, an observability configuration resource is associated with the service, and an `ObservabilityConfigurationArn` is specified.
     */
    public val observabilityEnabled: kotlin.Boolean = builder.observabilityEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceObservabilityConfiguration(")
        append("observabilityConfigurationArn=$observabilityConfigurationArn,")
        append("observabilityEnabled=$observabilityEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = observabilityConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (observabilityEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceObservabilityConfiguration

        if (observabilityConfigurationArn != other.observabilityConfigurationArn) return false
        if (observabilityEnabled != other.observabilityEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the observability configuration that is associated with the service. Specified only when `ObservabilityEnabled` is `true`.
         *
         * Specify an ARN with a name and a revision number to associate that revision. For example: `arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3`
         *
         * Specify just the name to associate the latest revision. For example: `arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing`
         */
        public var observabilityConfigurationArn: kotlin.String? = null
        /**
         * When `true`, an observability configuration resource is associated with the service, and an `ObservabilityConfigurationArn` is specified.
         */
        public var observabilityEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration) : this() {
            this.observabilityConfigurationArn = x.observabilityConfigurationArn
            this.observabilityEnabled = x.observabilityEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration = ServiceObservabilityConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
