// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an App Runner service. It can describe a service in any state, including deleted services.
 *
 * This type contains the full information about a service, including configuration details. It's returned by the [CreateService](https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html), [DescribeService](https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html), and [DeleteService](https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html) actions. A subset of this information is returned by the [ListServices](https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html) action using the [ServiceSummary](https://docs.aws.amazon.com/apprunner/latest/api/API_ServiceSummary.html) type.
 */
public class Service private constructor(builder: Builder) {
    /**
     * Summary information for the App Runner automatic scaling configuration resource that's associated with this service.
     */
    public val autoScalingConfigurationSummary: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary? = builder.autoScalingConfigurationSummary
    /**
     * The time when the App Runner service was created. It's in the Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The time when the App Runner service was deleted. It's in the Unix time stamp format.
     */
    public val deletedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedAt
    /**
     * The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The settings for the health check that App Runner performs to monitor the health of this service.
     */
    public val healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = builder.healthCheckConfiguration
    /**
     * The runtime configuration of instances (scaling units) of this service.
     */
    public val instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Configuration settings related to network traffic of the web application that this service runs.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The observability configuration of this service.
     */
    public val observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = builder.observabilityConfiguration
    /**
     * The Amazon Resource Name (ARN) of this service.
     */
    public val serviceArn: kotlin.String = requireNotNull(builder.serviceArn) { "A non-null value must be provided for serviceArn" }
    /**
     * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
     */
    public val serviceId: kotlin.String = requireNotNull(builder.serviceId) { "A non-null value must be provided for serviceId" }
    /**
     * The customer-provided service name.
     */
    public val serviceName: kotlin.String = requireNotNull(builder.serviceName) { "A non-null value must be provided for serviceName" }
    /**
     * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     */
    public val serviceUrl: kotlin.String? = builder.serviceUrl
    /**
     * The source deployed to the App Runner service. It can be a code or an image repository.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * The current state of the App Runner service. These particular values mean the following.
     * + `CREATE_FAILED` – The service failed to create. The failed service isn't usable, and still counts towards your service quota. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and rebuild your service using `UpdateService`.
     * + `DELETE_FAILED` – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.ServiceStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time when the App Runner service was last updated at. It's in the Unix time stamp format.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.Service = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Service(")
        append("autoScalingConfigurationSummary=$autoScalingConfigurationSummary,")
        append("createdAt=$createdAt,")
        append("deletedAt=$deletedAt,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("healthCheckConfiguration=$healthCheckConfiguration,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("networkConfiguration=$networkConfiguration,")
        append("observabilityConfiguration=$observabilityConfiguration,")
        append("serviceArn=$serviceArn,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceUrl=$serviceUrl,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationSummary?.hashCode() ?: 0
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (deletedAt?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (healthCheckConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceArn.hashCode())
        result = 31 * result + (serviceId.hashCode())
        result = 31 * result + (serviceName.hashCode())
        result = 31 * result + (serviceUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Service

        if (autoScalingConfigurationSummary != other.autoScalingConfigurationSummary) return false
        if (createdAt != other.createdAt) return false
        if (deletedAt != other.deletedAt) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (healthCheckConfiguration != other.healthCheckConfiguration) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (observabilityConfiguration != other.observabilityConfiguration) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceUrl != other.serviceUrl) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.Service = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Summary information for the App Runner automatic scaling configuration resource that's associated with this service.
         */
        public var autoScalingConfigurationSummary: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary? = null
        /**
         * The time when the App Runner service was created. It's in the Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the App Runner service was deleted. It's in the Unix time stamp format.
         */
        public var deletedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration? = null
        /**
         * The settings for the health check that App Runner performs to monitor the health of this service.
         */
        public var healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = null
        /**
         * The runtime configuration of instances (scaling units) of this service.
         */
        public var instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = null
        /**
         * Configuration settings related to network traffic of the web application that this service runs.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = null
        /**
         * The observability configuration of this service.
         */
        public var observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of this service.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The customer-provided service name.
         */
        public var serviceName: kotlin.String? = null
        /**
         * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
         */
        public var serviceUrl: kotlin.String? = null
        /**
         * The source deployed to the App Runner service. It can be a code or an image repository.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = null
        /**
         * The current state of the App Runner service. These particular values mean the following.
         * + `CREATE_FAILED` – The service failed to create. The failed service isn't usable, and still counts towards your service quota. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and rebuild your service using `UpdateService`.
         * + `DELETE_FAILED` – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.ServiceStatus? = null
        /**
         * The time when the App Runner service was last updated at. It's in the Unix time stamp format.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.Service) : this() {
            this.autoScalingConfigurationSummary = x.autoScalingConfigurationSummary
            this.createdAt = x.createdAt
            this.deletedAt = x.deletedAt
            this.encryptionConfiguration = x.encryptionConfiguration
            this.healthCheckConfiguration = x.healthCheckConfiguration
            this.instanceConfiguration = x.instanceConfiguration
            this.networkConfiguration = x.networkConfiguration
            this.observabilityConfiguration = x.observabilityConfiguration
            this.serviceArn = x.serviceArn
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceUrl = x.serviceUrl
            this.sourceConfiguration = x.sourceConfiguration
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.Service = Service(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary] inside the given [block]
         */
        public fun autoScalingConfigurationSummary(block: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary.Builder.() -> kotlin.Unit) {
            this.autoScalingConfigurationSummary = aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration] inside the given [block]
         */
        public fun healthCheckConfiguration(block: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.Builder.() -> kotlin.Unit) {
            this.healthCheckConfiguration = aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration] inside the given [block]
         */
        public fun instanceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceConfiguration = aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration] inside the given [block]
         */
        public fun observabilityConfiguration(block: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.Builder.() -> kotlin.Unit) {
            this.observabilityConfiguration = aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.SourceConfiguration] inside the given [block]
         */
        public fun sourceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.Builder.() -> kotlin.Unit) {
            this.sourceConfiguration = aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (serviceArn == null) serviceArn = ""
            if (serviceId == null) serviceId = ""
            if (serviceName == null) serviceName = ""
            if (status == null) status = ServiceStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
