// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for an operation that occurred on an App Runner service.
 */
public class OperationSummary private constructor(builder: Builder) {
    /**
     * The time when the operation ended. It's in the Unix time stamp format.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * A unique ID of this operation. It's unique in the scope of the App Runner service.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time when the operation started. It's in the Unix time stamp format.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The current state of the operation.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.OperationStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).
     */
    public val targetArn: kotlin.String? = builder.targetArn
    /**
     * The type of operation. It indicates a specific action that occured.
     */
    public val type: aws.sdk.kotlin.services.apprunner.model.OperationType? = builder.type
    /**
     * The time when the operation was last updated. It's in the Unix time stamp format.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.OperationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OperationSummary(")
        append("endedAt=$endedAt,")
        append("id=$id,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endedAt?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OperationSummary

        if (endedAt != other.endedAt) return false
        if (id != other.id) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.OperationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the operation ended. It's in the Unix time stamp format.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique ID of this operation. It's unique in the scope of the App Runner service.
         */
        public var id: kotlin.String? = null
        /**
         * The time when the operation started. It's in the Unix time stamp format.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the operation.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.OperationStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).
         */
        public var targetArn: kotlin.String? = null
        /**
         * The type of operation. It indicates a specific action that occured.
         */
        public var type: aws.sdk.kotlin.services.apprunner.model.OperationType? = null
        /**
         * The time when the operation was last updated. It's in the Unix time stamp format.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.OperationSummary) : this() {
            this.endedAt = x.endedAt
            this.id = x.id
            this.startedAt = x.startedAt
            this.status = x.status
            this.targetArn = x.targetArn
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.OperationSummary = OperationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
