// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Provides summary information about an App Runner observability configuration resource.
 *
 * This type contains limited information about an observability configuration. It includes only identification information, without configuration details. It's returned by the ListObservabilityConfigurations action. Complete configuration information is returned by the CreateObservabilityConfiguration, DescribeObservabilityConfiguration, and DeleteObservabilityConfiguration actions using the ObservabilityConfiguration type.
 */
public class ObservabilityConfigurationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of this observability configuration.
     */
    public val observabilityConfigurationArn: kotlin.String? = builder.observabilityConfigurationArn
    /**
     * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
     */
    public val observabilityConfigurationName: kotlin.String? = builder.observabilityConfigurationName
    /**
     * The revision of this observability configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `ObservabilityConfigurationName`.
     */
    public val observabilityConfigurationRevision: kotlin.Int = builder.observabilityConfigurationRevision

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObservabilityConfigurationSummary(")
        append("observabilityConfigurationArn=$observabilityConfigurationArn,")
        append("observabilityConfigurationName=$observabilityConfigurationName,")
        append("observabilityConfigurationRevision=$observabilityConfigurationRevision")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = observabilityConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (observabilityConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfigurationRevision)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObservabilityConfigurationSummary

        if (observabilityConfigurationArn != other.observabilityConfigurationArn) return false
        if (observabilityConfigurationName != other.observabilityConfigurationName) return false
        if (observabilityConfigurationRevision != other.observabilityConfigurationRevision) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of this observability configuration.
         */
        public var observabilityConfigurationArn: kotlin.String? = null
        /**
         * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
         */
        public var observabilityConfigurationName: kotlin.String? = null
        /**
         * The revision of this observability configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `ObservabilityConfigurationName`.
         */
        public var observabilityConfigurationRevision: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationSummary) : this() {
            this.observabilityConfigurationArn = x.observabilityConfigurationArn
            this.observabilityConfigurationName = x.observabilityConfigurationName
            this.observabilityConfigurationRevision = x.observabilityConfigurationRevision
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationSummary = ObservabilityConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
