// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an App Runner observability configuration resource. Multiple revisions of a configuration have the same `ObservabilityConfigurationName` and different `ObservabilityConfigurationRevision` values.
 *
 * The resource is designed to configure multiple features (currently one feature, tracing). This type contains optional members that describe the configuration of these features (currently one member, `TraceConfiguration`). If a feature member isn't specified, the feature isn't enabled.
 */
public class ObservabilityConfiguration private constructor(builder: Builder) {
    /**
     * The time when the observability configuration was created. It's in Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The time when the observability configuration was deleted. It's in Unix time stamp format.
     */
    public val deletedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedAt
    /**
     * It's set to `true` for the configuration with the highest `Revision` among all configurations that share the same `ObservabilityConfigurationName`. It's set to `false` otherwise.
     */
    public val latest: kotlin.Boolean = builder.latest
    /**
     * The Amazon Resource Name (ARN) of this observability configuration.
     */
    public val observabilityConfigurationArn: kotlin.String? = builder.observabilityConfigurationArn
    /**
     * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
     */
    public val observabilityConfigurationName: kotlin.String? = builder.observabilityConfigurationName
    /**
     * The revision of this observability configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `ObservabilityConfigurationName`.
     */
    public val observabilityConfigurationRevision: kotlin.Int = builder.observabilityConfigurationRevision
    /**
     * The current state of the observability configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationStatus? = builder.status
    /**
     * The configuration of the tracing feature within this observability configuration. If not specified, tracing isn't enabled.
     */
    public val traceConfiguration: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration? = builder.traceConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObservabilityConfiguration(")
        append("createdAt=$createdAt,")
        append("deletedAt=$deletedAt,")
        append("latest=$latest,")
        append("observabilityConfigurationArn=$observabilityConfigurationArn,")
        append("observabilityConfigurationName=$observabilityConfigurationName,")
        append("observabilityConfigurationRevision=$observabilityConfigurationRevision,")
        append("status=$status,")
        append("traceConfiguration=$traceConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (deletedAt?.hashCode() ?: 0)
        result = 31 * result + (latest.hashCode())
        result = 31 * result + (observabilityConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfigurationRevision)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (traceConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObservabilityConfiguration

        if (createdAt != other.createdAt) return false
        if (deletedAt != other.deletedAt) return false
        if (latest != other.latest) return false
        if (observabilityConfigurationArn != other.observabilityConfigurationArn) return false
        if (observabilityConfigurationName != other.observabilityConfigurationName) return false
        if (observabilityConfigurationRevision != other.observabilityConfigurationRevision) return false
        if (status != other.status) return false
        if (traceConfiguration != other.traceConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the observability configuration was created. It's in Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the observability configuration was deleted. It's in Unix time stamp format.
         */
        public var deletedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * It's set to `true` for the configuration with the highest `Revision` among all configurations that share the same `ObservabilityConfigurationName`. It's set to `false` otherwise.
         */
        public var latest: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of this observability configuration.
         */
        public var observabilityConfigurationArn: kotlin.String? = null
        /**
         * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
         */
        public var observabilityConfigurationName: kotlin.String? = null
        /**
         * The revision of this observability configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `ObservabilityConfigurationName`.
         */
        public var observabilityConfigurationRevision: kotlin.Int = 0
        /**
         * The current state of the observability configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.ObservabilityConfigurationStatus? = null
        /**
         * The configuration of the tracing feature within this observability configuration. If not specified, tracing isn't enabled.
         */
        public var traceConfiguration: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ObservabilityConfiguration) : this() {
            this.createdAt = x.createdAt
            this.deletedAt = x.deletedAt
            this.latest = x.latest
            this.observabilityConfigurationArn = x.observabilityConfigurationArn
            this.observabilityConfigurationName = x.observabilityConfigurationName
            this.observabilityConfigurationRevision = x.observabilityConfigurationRevision
            this.status = x.status
            this.traceConfiguration = x.traceConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ObservabilityConfiguration = ObservabilityConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.TraceConfiguration] inside the given [block]
         */
        public fun traceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration.Builder.() -> kotlin.Unit) {
            this.traceConfiguration = aws.sdk.kotlin.services.apprunner.model.TraceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
