// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class ListServicesForAutoScalingConfigurationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to list the services for.
     *
     * The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either `.../<i>name</i> ` or `.../<i>name</i>/<i>revision</i> `. If a revision isn't specified, the latest active revision is used.
     */
    public val autoScalingConfigurationArn: kotlin.String? = builder.autoScalingConfigurationArn
    /**
     * The maximum number of results to include in each response (result page). It's used for a paginated request.
     *
     * If you don't specify `MaxResults`, the request retrieves all available results in a single response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request.
     *
     * If you don't specify `NextToken`, the request retrieves the first result page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListServicesForAutoScalingConfigurationRequest(")
        append("autoScalingConfigurationArn=$autoScalingConfigurationArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListServicesForAutoScalingConfigurationRequest

        if (autoScalingConfigurationArn != other.autoScalingConfigurationArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to list the services for.
         *
         * The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either `.../<i>name</i> ` or `.../<i>name</i>/<i>revision</i> `. If a revision isn't specified, the latest active revision is used.
         */
        public var autoScalingConfigurationArn: kotlin.String? = null
        /**
         * The maximum number of results to include in each response (result page). It's used for a paginated request.
         *
         * If you don't specify `MaxResults`, the request retrieves all available results in a single response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request.
         *
         * If you don't specify `NextToken`, the request retrieves the first result page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest) : this() {
            this.autoScalingConfigurationArn = x.autoScalingConfigurationArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest = ListServicesForAutoScalingConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
