// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the runtime configuration of an App Runner service instance (scaling unit).
 */
public class InstanceConfiguration private constructor(builder: Builder) {
    /**
     * The number of CPU units reserved for each instance of your App Runner service.
     *
     * Default: `1 vCPU`
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.
     */
    public val instanceRoleArn: kotlin.String? = builder.instanceRoleArn
    /**
     * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
     *
     * Default: `2 GB`
     */
    public val memory: kotlin.String? = builder.memory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceConfiguration(")
        append("cpu=$cpu,")
        append("instanceRoleArn=$instanceRoleArn,")
        append("memory=$memory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpu?.hashCode() ?: 0
        result = 31 * result + (instanceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceConfiguration

        if (cpu != other.cpu) return false
        if (instanceRoleArn != other.instanceRoleArn) return false
        if (memory != other.memory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of CPU units reserved for each instance of your App Runner service.
         *
         * Default: `1 vCPU`
         */
        public var cpu: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.
         */
        public var instanceRoleArn: kotlin.String? = null
        /**
         * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
         *
         * Default: `2 GB`
         */
        public var memory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration) : this() {
            this.cpu = x.cpu
            this.instanceRoleArn = x.instanceRoleArn
            this.memory = x.memory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration = InstanceConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
