// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes a source image repository.
 */
public class ImageRepository private constructor(builder: Builder) {
    /**
     * Configuration for running the identified image.
     */
    public val imageConfiguration: aws.sdk.kotlin.services.apprunner.model.ImageConfiguration? = builder.imageConfiguration
    /**
     * The identifier of an image.
     *
     * For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see [Pulling an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html) in the *Amazon ECR User Guide*.
     */
    public val imageIdentifier: kotlin.String = requireNotNull(builder.imageIdentifier) { "A non-null value must be provided for imageIdentifier" }
    /**
     * The type of the image repository. This reflects the repository provider and whether the repository is private or public.
     */
    public val imageRepositoryType: aws.sdk.kotlin.services.apprunner.model.ImageRepositoryType = requireNotNull(builder.imageRepositoryType) { "A non-null value must be provided for imageRepositoryType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ImageRepository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageRepository(")
        append("imageConfiguration=$imageConfiguration,")
        append("imageIdentifier=$imageIdentifier,")
        append("imageRepositoryType=$imageRepositoryType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageConfiguration?.hashCode() ?: 0
        result = 31 * result + (imageIdentifier.hashCode())
        result = 31 * result + (imageRepositoryType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageRepository

        if (imageConfiguration != other.imageConfiguration) return false
        if (imageIdentifier != other.imageIdentifier) return false
        if (imageRepositoryType != other.imageRepositoryType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ImageRepository = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration for running the identified image.
         */
        public var imageConfiguration: aws.sdk.kotlin.services.apprunner.model.ImageConfiguration? = null
        /**
         * The identifier of an image.
         *
         * For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see [Pulling an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html) in the *Amazon ECR User Guide*.
         */
        public var imageIdentifier: kotlin.String? = null
        /**
         * The type of the image repository. This reflects the repository provider and whether the repository is private or public.
         */
        public var imageRepositoryType: aws.sdk.kotlin.services.apprunner.model.ImageRepositoryType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ImageRepository) : this() {
            this.imageConfiguration = x.imageConfiguration
            this.imageIdentifier = x.imageIdentifier
            this.imageRepositoryType = x.imageRepositoryType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ImageRepository = ImageRepository(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.ImageConfiguration] inside the given [block]
         */
        public fun imageConfiguration(block: aws.sdk.kotlin.services.apprunner.model.ImageConfiguration.Builder.() -> kotlin.Unit) {
            this.imageConfiguration = aws.sdk.kotlin.services.apprunner.model.ImageConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (imageIdentifier == null) imageIdentifier = ""
            if (imageRepositoryType == null) imageRepositoryType = ImageRepositoryType.SdkUnknown("no value provided")
            return this
        }
    }
}
