// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the configuration that App Runner uses to run an App Runner service using an image pulled from a source image repository.
 */
public class ImageConfiguration private constructor(builder: Builder) {
    /**
     * The port that your application listens to in the container.
     *
     * Default: `8080`
     */
    public val port: kotlin.String? = builder.port
    /**
     * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
     *
     * +  If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Amazon Web Services Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.
     * +  Currently, cross account referencing of Amazon Web Services Systems Manager Parameter Store parameter is not supported.
     */
    public val runtimeEnvironmentSecrets: Map<String, String>? = builder.runtimeEnvironmentSecrets
    /**
     * Environment variables that are available to your running App Runner service. An array of key-value pairs.
     */
    public val runtimeEnvironmentVariables: Map<String, String>? = builder.runtimeEnvironmentVariables
    /**
     * An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
     */
    public val startCommand: kotlin.String? = builder.startCommand

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.ImageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageConfiguration(")
        append("port=$port,")
        append("runtimeEnvironmentSecrets=$runtimeEnvironmentSecrets,")
        append("runtimeEnvironmentVariables=$runtimeEnvironmentVariables,")
        append("startCommand=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = port?.hashCode() ?: 0
        result = 31 * result + (runtimeEnvironmentSecrets?.hashCode() ?: 0)
        result = 31 * result + (runtimeEnvironmentVariables?.hashCode() ?: 0)
        result = 31 * result + (startCommand?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageConfiguration

        if (port != other.port) return false
        if (runtimeEnvironmentSecrets != other.runtimeEnvironmentSecrets) return false
        if (runtimeEnvironmentVariables != other.runtimeEnvironmentVariables) return false
        if (startCommand != other.startCommand) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.ImageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The port that your application listens to in the container.
         *
         * Default: `8080`
         */
        public var port: kotlin.String? = null
        /**
         * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
         *
         * +  If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Amazon Web Services Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.
         * +  Currently, cross account referencing of Amazon Web Services Systems Manager Parameter Store parameter is not supported.
         */
        public var runtimeEnvironmentSecrets: Map<String, String>? = null
        /**
         * Environment variables that are available to your running App Runner service. An array of key-value pairs.
         */
        public var runtimeEnvironmentVariables: Map<String, String>? = null
        /**
         * An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
         */
        public var startCommand: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.ImageConfiguration) : this() {
            this.port = x.port
            this.runtimeEnvironmentSecrets = x.runtimeEnvironmentSecrets
            this.runtimeEnvironmentVariables = x.runtimeEnvironmentVariables
            this.startCommand = x.startCommand
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.ImageConfiguration = ImageConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
