// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the settings for the health check that App Runner performs to monitor the health of a service.
 */
public class HealthCheckConfiguration private constructor(builder: Builder) {
    /**
     * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
     *
     * Default: `1`
     */
    public val healthyThreshold: kotlin.Int? = builder.healthyThreshold
    /**
     * The time interval, in seconds, between health checks.
     *
     * Default: `5`
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The URL that health check requests are sent to.
     *
     * `Path` is only applicable when you set `Protocol` to `HTTP`.
     *
     * Default: `"/"`
     */
    public val path: kotlin.String? = builder.path
    /**
     * The IP protocol that App Runner uses to perform health checks for your service.
     *
     * If you set `Protocol` to `HTTP`, App Runner sends health check requests to the HTTP path specified by `Path`.
     *
     * Default: `TCP`
     */
    public val protocol: aws.sdk.kotlin.services.apprunner.model.HealthCheckProtocol? = builder.protocol
    /**
     * The time, in seconds, to wait for a health check response before deciding it failed.
     *
     * Default: `2`
     */
    public val timeout: kotlin.Int? = builder.timeout
    /**
     * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
     *
     * Default: `5`
     */
    public val unhealthyThreshold: kotlin.Int? = builder.unhealthyThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheckConfiguration(")
        append("healthyThreshold=$healthyThreshold,")
        append("interval=$interval,")
        append("path=$path,")
        append("protocol=$protocol,")
        append("timeout=$timeout,")
        append("unhealthyThreshold=$unhealthyThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        result = 31 * result + (unhealthyThreshold ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheckConfiguration

        if (healthyThreshold != other.healthyThreshold) return false
        if (interval != other.interval) return false
        if (path != other.path) return false
        if (protocol != other.protocol) return false
        if (timeout != other.timeout) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
         *
         * Default: `1`
         */
        public var healthyThreshold: kotlin.Int? = null
        /**
         * The time interval, in seconds, between health checks.
         *
         * Default: `5`
         */
        public var interval: kotlin.Int? = null
        /**
         * The URL that health check requests are sent to.
         *
         * `Path` is only applicable when you set `Protocol` to `HTTP`.
         *
         * Default: `"/"`
         */
        public var path: kotlin.String? = null
        /**
         * The IP protocol that App Runner uses to perform health checks for your service.
         *
         * If you set `Protocol` to `HTTP`, App Runner sends health check requests to the HTTP path specified by `Path`.
         *
         * Default: `TCP`
         */
        public var protocol: aws.sdk.kotlin.services.apprunner.model.HealthCheckProtocol? = null
        /**
         * The time, in seconds, to wait for a health check response before deciding it failed.
         *
         * Default: `2`
         */
        public var timeout: kotlin.Int? = null
        /**
         * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
         *
         * Default: `5`
         */
        public var unhealthyThreshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.interval = x.interval
            this.path = x.path
            this.protocol = x.protocol
            this.timeout = x.timeout
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration = HealthCheckConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
