// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes configuration settings related to outbound network traffic of an App Runner service.
 */
public class EgressConfiguration private constructor(builder: Builder) {
    /**
     * The type of egress configuration.
     *
     * Set to `DEFAULT` for access to resources hosted on public networks.
     *
     * Set to `VPC` to associate your service to a custom VPC specified by `VpcConnectorArn`.
     */
    public val egressType: aws.sdk.kotlin.services.apprunner.model.EgressType? = builder.egressType
    /**
     * The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
     */
    public val vpcConnectorArn: kotlin.String? = builder.vpcConnectorArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.EgressConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EgressConfiguration(")
        append("egressType=$egressType,")
        append("vpcConnectorArn=$vpcConnectorArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = egressType?.hashCode() ?: 0
        result = 31 * result + (vpcConnectorArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EgressConfiguration

        if (egressType != other.egressType) return false
        if (vpcConnectorArn != other.vpcConnectorArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.EgressConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of egress configuration.
         *
         * Set to `DEFAULT` for access to resources hosted on public networks.
         *
         * Set to `VPC` to associate your service to a custom VPC specified by `VpcConnectorArn`.
         */
        public var egressType: aws.sdk.kotlin.services.apprunner.model.EgressType? = null
        /**
         * The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
         */
        public var vpcConnectorArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.EgressConfiguration) : this() {
            this.egressType = x.egressType
            this.vpcConnectorArn = x.vpcConnectorArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.EgressConfiguration = EgressConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
