// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class DescribeCustomDomainsResponse private constructor(builder: Builder) {
    /**
     * A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to `MaxResults` records per call.
     */
    public val customDomains: List<CustomDomain> = requireNotNull(builder.customDomains) { "A non-null value must be provided for customDomains" }
    /**
     * The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.
     */
    public val dnsTarget: kotlin.String = requireNotNull(builder.dnsTarget) { "A non-null value must be provided for dnsTarget" }
    /**
     * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.
     */
    public val serviceArn: kotlin.String = requireNotNull(builder.serviceArn) { "A non-null value must be provided for serviceArn" }
    /**
     * DNS Target records for the custom domains of this Amazon VPC.
     */
    public val vpcDnsTargets: List<VpcDnsTarget> = requireNotNull(builder.vpcDnsTargets) { "A non-null value must be provided for vpcDnsTargets" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCustomDomainsResponse(")
        append("customDomains=$customDomains,")
        append("dnsTarget=$dnsTarget,")
        append("nextToken=$nextToken,")
        append("serviceArn=$serviceArn,")
        append("vpcDnsTargets=$vpcDnsTargets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDomains.hashCode()
        result = 31 * result + (dnsTarget.hashCode())
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceArn.hashCode())
        result = 31 * result + (vpcDnsTargets.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCustomDomainsResponse

        if (customDomains != other.customDomains) return false
        if (dnsTarget != other.dnsTarget) return false
        if (nextToken != other.nextToken) return false
        if (serviceArn != other.serviceArn) return false
        if (vpcDnsTargets != other.vpcDnsTargets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to `MaxResults` records per call.
         */
        public var customDomains: List<CustomDomain>? = null
        /**
         * The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.
         */
        public var dnsTarget: kotlin.String? = null
        /**
         * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * DNS Target records for the custom domains of this Amazon VPC.
         */
        public var vpcDnsTargets: List<VpcDnsTarget>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse) : this() {
            this.customDomains = x.customDomains
            this.dnsTarget = x.dnsTarget
            this.nextToken = x.nextToken
            this.serviceArn = x.serviceArn
            this.vpcDnsTargets = x.vpcDnsTargets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse = DescribeCustomDomainsResponse(this)

        internal fun correctErrors(): Builder {
            if (customDomains == null) customDomains = emptyList()
            if (dnsTarget == null) dnsTarget = ""
            if (serviceArn == null) serviceArn = ""
            if (vpcDnsTargets == null) vpcDnsTargets = emptyList()
            return this
        }
    }
}
