// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes a custom domain that's associated with an App Runner service.
 */
public class CustomDomain private constructor(builder: Builder) {
    /**
     * A list of certificate CNAME records that's used for this domain name.
     */
    public val certificateValidationRecords: List<CertificateValidationRecord>? = builder.certificateValidationRecords
    /**
     * An associated custom domain endpoint. It can be a root domain (for example, `example.com`), a subdomain (for example, `login.example.com` or `admin.login.example.com`), or a wildcard (for example, `*.example.com`).
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * When `true`, the subdomain `www.<i>DomainName</i> ` is associated with the App Runner service in addition to the base domain.
     */
    public val enableWwwSubdomain: kotlin.Boolean = requireNotNull(builder.enableWwwSubdomain) { "A non-null value must be provided for enableWwwSubdomain" }
    /**
     * The current state of the domain name association.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.CustomDomainAssociationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CustomDomain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDomain(")
        append("certificateValidationRecords=$certificateValidationRecords,")
        append("domainName=$domainName,")
        append("enableWwwSubdomain=$enableWwwSubdomain,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateValidationRecords?.hashCode() ?: 0
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (enableWwwSubdomain.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomDomain

        if (certificateValidationRecords != other.certificateValidationRecords) return false
        if (domainName != other.domainName) return false
        if (enableWwwSubdomain != other.enableWwwSubdomain) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CustomDomain = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of certificate CNAME records that's used for this domain name.
         */
        public var certificateValidationRecords: List<CertificateValidationRecord>? = null
        /**
         * An associated custom domain endpoint. It can be a root domain (for example, `example.com`), a subdomain (for example, `login.example.com` or `admin.login.example.com`), or a wildcard (for example, `*.example.com`).
         */
        public var domainName: kotlin.String? = null
        /**
         * When `true`, the subdomain `www.<i>DomainName</i> ` is associated with the App Runner service in addition to the base domain.
         */
        public var enableWwwSubdomain: kotlin.Boolean? = null
        /**
         * The current state of the domain name association.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.CustomDomainAssociationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CustomDomain) : this() {
            this.certificateValidationRecords = x.certificateValidationRecords
            this.domainName = x.domainName
            this.enableWwwSubdomain = x.enableWwwSubdomain
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CustomDomain = CustomDomain(this)

        internal fun correctErrors(): Builder {
            if (domainName == null) domainName = ""
            if (enableWwwSubdomain == null) enableWwwSubdomain = false
            if (status == null) status = CustomDomainAssociationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
