// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     *
     * Specify an ARN with a name and a revision number to associate that revision. For example: `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3`
     *
     * Specify just the name to associate the latest revision. For example: `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability`
     */
    public val autoScalingConfigurationArn: kotlin.String? = builder.autoScalingConfigurationArn
    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
     */
    public val healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = builder.healthCheckConfiguration
    /**
     * The runtime configuration of instances (scaling units) of your service.
     */
    public val instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The observability configuration of your service.
     */
    public val observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = builder.observabilityConfiguration
    /**
     * A name for the App Runner service. It must be unique across all the running App Runner services in your Amazon Web Services account in the Amazon Web Services Region.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The source to deploy to the App Runner service. It can be a code or an image repository.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("autoScalingConfigurationArn=$autoScalingConfigurationArn,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("healthCheckConfiguration=$healthCheckConfiguration,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("networkConfiguration=$networkConfiguration,")
        append("observabilityConfiguration=$observabilityConfiguration,")
        append("serviceName=$serviceName,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (healthCheckConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (observabilityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (autoScalingConfigurationArn != other.autoScalingConfigurationArn) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (healthCheckConfiguration != other.healthCheckConfiguration) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (observabilityConfiguration != other.observabilityConfiguration) return false
        if (serviceName != other.serviceName) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CreateServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
         *
         * Specify an ARN with a name and a revision number to associate that revision. For example: `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3`
         *
         * Specify just the name to associate the latest revision. For example: `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability`
         */
        public var autoScalingConfigurationArn: kotlin.String? = null
        /**
         * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration? = null
        /**
         * The settings for the health check that App Runner performs to monitor the health of the App Runner service.
         */
        public var healthCheckConfiguration: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration? = null
        /**
         * The runtime configuration of instances (scaling units) of your service.
         */
        public var instanceConfiguration: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration? = null
        /**
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration? = null
        /**
         * The observability configuration of your service.
         */
        public var observabilityConfiguration: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration? = null
        /**
         * A name for the App Runner service. It must be unique across all the running App Runner services in your Amazon Web Services account in the Amazon Web Services Region.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The source to deploy to the App Runner service. It can be a code or an image repository.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration? = null
        /**
         * An optional list of metadata items that you can associate with the App Runner service resource. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CreateServiceRequest) : this() {
            this.autoScalingConfigurationArn = x.autoScalingConfigurationArn
            this.encryptionConfiguration = x.encryptionConfiguration
            this.healthCheckConfiguration = x.healthCheckConfiguration
            this.instanceConfiguration = x.instanceConfiguration
            this.networkConfiguration = x.networkConfiguration
            this.observabilityConfiguration = x.observabilityConfiguration
            this.serviceName = x.serviceName
            this.sourceConfiguration = x.sourceConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CreateServiceRequest = CreateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.apprunner.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration] inside the given [block]
         */
        public fun healthCheckConfiguration(block: aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.Builder.() -> kotlin.Unit) {
            this.healthCheckConfiguration = aws.sdk.kotlin.services.apprunner.model.HealthCheckConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration] inside the given [block]
         */
        public fun instanceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceConfiguration = aws.sdk.kotlin.services.apprunner.model.InstanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.apprunner.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration] inside the given [block]
         */
        public fun observabilityConfiguration(block: aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.Builder.() -> kotlin.Unit) {
            this.observabilityConfiguration = aws.sdk.kotlin.services.apprunner.model.ServiceObservabilityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.SourceConfiguration] inside the given [block]
         */
        public fun sourceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.Builder.() -> kotlin.Unit) {
            this.sourceConfiguration = aws.sdk.kotlin.services.apprunner.model.SourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
