// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class CreateObservabilityConfigurationRequest private constructor(builder: Builder) {
    /**
     * A name for the observability configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number `1` of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
     *
     * The name `DefaultConfiguration` is reserved. You can't use it to create a new observability configuration, and you can't create a revision of it.
     *
     * When you want to use your own observability configuration for your App Runner service, *create a configuration with a different name*, and then provide it when you create or update your service.
     */
    public val observabilityConfigurationName: kotlin.String? = builder.observabilityConfigurationName
    /**
     * A list of metadata items that you can associate with your observability configuration resource. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing.
     */
    public val traceConfiguration: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration? = builder.traceConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateObservabilityConfigurationRequest(")
        append("observabilityConfigurationName=$observabilityConfigurationName,")
        append("tags=$tags,")
        append("traceConfiguration=$traceConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = observabilityConfigurationName?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (traceConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateObservabilityConfigurationRequest

        if (observabilityConfigurationName != other.observabilityConfigurationName) return false
        if (tags != other.tags) return false
        if (traceConfiguration != other.traceConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A name for the observability configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number `1` of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
         *
         * The name `DefaultConfiguration` is reserved. You can't use it to create a new observability configuration, and you can't create a revision of it.
         *
         * When you want to use your own observability configuration for your App Runner service, *create a configuration with a different name*, and then provide it when you create or update your service.
         */
        public var observabilityConfigurationName: kotlin.String? = null
        /**
         * A list of metadata items that you can associate with your observability configuration resource. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null
        /**
         * The configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing.
         */
        public var traceConfiguration: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationRequest) : this() {
            this.observabilityConfigurationName = x.observabilityConfigurationName
            this.tags = x.tags
            this.traceConfiguration = x.traceConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationRequest = CreateObservabilityConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.TraceConfiguration] inside the given [block]
         */
        public fun traceConfiguration(block: aws.sdk.kotlin.services.apprunner.model.TraceConfiguration.Builder.() -> kotlin.Unit) {
            this.traceConfiguration = aws.sdk.kotlin.services.apprunner.model.TraceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
