// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



public class CreateAutoScalingConfigurationRequest private constructor(builder: Builder) {
    /**
     * A name for the auto scaling configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number `1` of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
     *
     * Prior to the release of [Auto scale configuration enhancements](https://docs.aws.amazon.com/apprunner/latest/relnotes/release-2023-09-22-auto-scale-config.html), the name `DefaultConfiguration` was reserved.
     *
     * This restriction is no longer in place. You can now manage `DefaultConfiguration` the same way you manage your custom auto scaling configurations. This means you can do the following with the `DefaultConfiguration` that App Runner provides:
     * + Create new revisions of the `DefaultConfiguration`.
     * + Delete the revisions of the `DefaultConfiguration`.
     * + Delete the auto scaling configuration for which the App Runner `DefaultConfiguration` was created.
     * + If you delete the auto scaling configuration you can create another custom auto scaling configuration with the same `DefaultConfiguration` name. The original `DefaultConfiguration` resource provided by App Runner remains in your account unless you make changes to it.
     */
    public val autoScalingConfigurationName: kotlin.String? = builder.autoScalingConfigurationName
    /**
     * The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales up your service.
     *
     * Default: `100`
     */
    public val maxConcurrency: kotlin.Int? = builder.maxConcurrency
    /**
     * The maximum number of instances that your service scales up to. At most `MaxSize` instances actively serve traffic for your service.
     *
     * Default: `25`
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum number of instances that App Runner provisions for your service. The service always has at least `MinSize` provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.
     *
     * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.
     *
     * Default: `1`
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAutoScalingConfigurationRequest(")
        append("autoScalingConfigurationName=$autoScalingConfigurationName,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationName?.hashCode() ?: 0
        result = 31 * result + (maxConcurrency ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAutoScalingConfigurationRequest

        if (autoScalingConfigurationName != other.autoScalingConfigurationName) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A name for the auto scaling configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number `1` of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
         *
         * Prior to the release of [Auto scale configuration enhancements](https://docs.aws.amazon.com/apprunner/latest/relnotes/release-2023-09-22-auto-scale-config.html), the name `DefaultConfiguration` was reserved.
         *
         * This restriction is no longer in place. You can now manage `DefaultConfiguration` the same way you manage your custom auto scaling configurations. This means you can do the following with the `DefaultConfiguration` that App Runner provides:
         * + Create new revisions of the `DefaultConfiguration`.
         * + Delete the revisions of the `DefaultConfiguration`.
         * + Delete the auto scaling configuration for which the App Runner `DefaultConfiguration` was created.
         * + If you delete the auto scaling configuration you can create another custom auto scaling configuration with the same `DefaultConfiguration` name. The original `DefaultConfiguration` resource provided by App Runner remains in your account unless you make changes to it.
         */
        public var autoScalingConfigurationName: kotlin.String? = null
        /**
         * The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales up your service.
         *
         * Default: `100`
         */
        public var maxConcurrency: kotlin.Int? = null
        /**
         * The maximum number of instances that your service scales up to. At most `MaxSize` instances actively serve traffic for your service.
         *
         * Default: `25`
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum number of instances that App Runner provisions for your service. The service always has at least `MinSize` provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.
         *
         * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.
         *
         * Default: `1`
         */
        public var minSize: kotlin.Int? = null
        /**
         * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationRequest) : this() {
            this.autoScalingConfigurationName = x.autoScalingConfigurationName
            this.maxConcurrency = x.maxConcurrency
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationRequest = CreateAutoScalingConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
