// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes a source code repository.
 */
public class CodeRepository private constructor(builder: Builder) {
    /**
     * Configuration for building and running the service from a source code repository.
     *
     * `CodeConfiguration` is required only for `CreateService` request.
     */
    public val codeConfiguration: aws.sdk.kotlin.services.apprunner.model.CodeConfiguration? = builder.codeConfiguration
    /**
     * The location of the repository that contains the source code.
     */
    public val repositoryUrl: kotlin.String = requireNotNull(builder.repositoryUrl) { "A non-null value must be provided for repositoryUrl" }
    /**
     * The version that should be used within the source code repository.
     */
    public val sourceCodeVersion: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion? = builder.sourceCodeVersion
    /**
     * The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
     */
    public val sourceDirectory: kotlin.String? = builder.sourceDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CodeRepository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeRepository(")
        append("codeConfiguration=$codeConfiguration,")
        append("repositoryUrl=$repositoryUrl,")
        append("sourceCodeVersion=$sourceCodeVersion,")
        append("sourceDirectory=$sourceDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeConfiguration?.hashCode() ?: 0
        result = 31 * result + (repositoryUrl.hashCode())
        result = 31 * result + (sourceCodeVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeRepository

        if (codeConfiguration != other.codeConfiguration) return false
        if (repositoryUrl != other.repositoryUrl) return false
        if (sourceCodeVersion != other.sourceCodeVersion) return false
        if (sourceDirectory != other.sourceDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CodeRepository = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration for building and running the service from a source code repository.
         *
         * `CodeConfiguration` is required only for `CreateService` request.
         */
        public var codeConfiguration: aws.sdk.kotlin.services.apprunner.model.CodeConfiguration? = null
        /**
         * The location of the repository that contains the source code.
         */
        public var repositoryUrl: kotlin.String? = null
        /**
         * The version that should be used within the source code repository.
         */
        public var sourceCodeVersion: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion? = null
        /**
         * The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
         */
        public var sourceDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CodeRepository) : this() {
            this.codeConfiguration = x.codeConfiguration
            this.repositoryUrl = x.repositoryUrl
            this.sourceCodeVersion = x.sourceCodeVersion
            this.sourceDirectory = x.sourceDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CodeRepository = CodeRepository(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.CodeConfiguration] inside the given [block]
         */
        public fun codeConfiguration(block: aws.sdk.kotlin.services.apprunner.model.CodeConfiguration.Builder.() -> kotlin.Unit) {
            this.codeConfiguration = aws.sdk.kotlin.services.apprunner.model.CodeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion] inside the given [block]
         */
        public fun sourceCodeVersion(block: aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion.Builder.() -> kotlin.Unit) {
            this.sourceCodeVersion = aws.sdk.kotlin.services.apprunner.model.SourceCodeVersion.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (repositoryUrl == null) repositoryUrl = ""
            return this
        }
    }
}
