// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the basic configuration needed for building and running an App Runner service. This type doesn't support the full set of possible configuration options. Fur full configuration capabilities, use a `apprunner.yaml` file in the source code repository.
 */
public class CodeConfigurationValues private constructor(builder: Builder) {
    /**
     * The command App Runner runs to build your application.
     */
    public val buildCommand: kotlin.String? = builder.buildCommand
    /**
     * The port that your application listens to in the container.
     *
     * Default: `8080`
     */
    public val port: kotlin.String? = builder.port
    /**
     * A runtime environment type for building and running an App Runner service. It represents a programming language runtime.
     */
    public val runtime: aws.sdk.kotlin.services.apprunner.model.Runtime = requireNotNull(builder.runtime) { "A non-null value must be provided for runtime" }
    /**
     * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
     *
     * +  If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Amazon Web Services Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.
     * +  Currently, cross account referencing of Amazon Web Services Systems Manager Parameter Store parameter is not supported.
     */
    public val runtimeEnvironmentSecrets: Map<String, String>? = builder.runtimeEnvironmentSecrets
    /**
     * The environment variables that are available to your running App Runner service. An array of key-value pairs.
     */
    public val runtimeEnvironmentVariables: Map<String, String>? = builder.runtimeEnvironmentVariables
    /**
     * The command App Runner runs to start your application.
     */
    public val startCommand: kotlin.String? = builder.startCommand

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeConfigurationValues(")
        append("buildCommand=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("runtime=$runtime,")
        append("runtimeEnvironmentSecrets=$runtimeEnvironmentSecrets,")
        append("runtimeEnvironmentVariables=$runtimeEnvironmentVariables,")
        append("startCommand=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildCommand?.hashCode() ?: 0
        result = 31 * result + (port?.hashCode() ?: 0)
        result = 31 * result + (runtime.hashCode())
        result = 31 * result + (runtimeEnvironmentSecrets?.hashCode() ?: 0)
        result = 31 * result + (runtimeEnvironmentVariables?.hashCode() ?: 0)
        result = 31 * result + (startCommand?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeConfigurationValues

        if (buildCommand != other.buildCommand) return false
        if (port != other.port) return false
        if (runtime != other.runtime) return false
        if (runtimeEnvironmentSecrets != other.runtimeEnvironmentSecrets) return false
        if (runtimeEnvironmentVariables != other.runtimeEnvironmentVariables) return false
        if (startCommand != other.startCommand) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command App Runner runs to build your application.
         */
        public var buildCommand: kotlin.String? = null
        /**
         * The port that your application listens to in the container.
         *
         * Default: `8080`
         */
        public var port: kotlin.String? = null
        /**
         * A runtime environment type for building and running an App Runner service. It represents a programming language runtime.
         */
        public var runtime: aws.sdk.kotlin.services.apprunner.model.Runtime? = null
        /**
         * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable. The supported values are either the full Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.
         *
         * +  If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Amazon Web Services Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.
         * +  Currently, cross account referencing of Amazon Web Services Systems Manager Parameter Store parameter is not supported.
         */
        public var runtimeEnvironmentSecrets: Map<String, String>? = null
        /**
         * The environment variables that are available to your running App Runner service. An array of key-value pairs.
         */
        public var runtimeEnvironmentVariables: Map<String, String>? = null
        /**
         * The command App Runner runs to start your application.
         */
        public var startCommand: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues) : this() {
            this.buildCommand = x.buildCommand
            this.port = x.port
            this.runtime = x.runtime
            this.runtimeEnvironmentSecrets = x.runtimeEnvironmentSecrets
            this.runtimeEnvironmentVariables = x.runtimeEnvironmentVariables
            this.startCommand = x.startCommand
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues = CodeConfigurationValues(this)

        internal fun correctErrors(): Builder {
            if (runtime == null) runtime = Runtime.SdkUnknown("no value provided")
            return this
        }
    }
}
