// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes the configuration that App Runner uses to build and run an App Runner service from a source code repository.
 */
public class CodeConfiguration private constructor(builder: Builder) {
    /**
     * The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a `apprunner.yaml` file in the source code repository (or ignoring the file if it exists).
     */
    public val codeConfigurationValues: aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues? = builder.codeConfigurationValues
    /**
     * The source of the App Runner configuration. Values are interpreted as follows:
     * + `REPOSITORY` – App Runner reads configuration values from the `apprunner.yaml` file in the source code repository and ignores `CodeConfigurationValues`.
     * + `API` – App Runner uses configuration values provided in `CodeConfigurationValues` and ignores the `apprunner.yaml` file in the source code repository.
     */
    public val configurationSource: aws.sdk.kotlin.services.apprunner.model.ConfigurationSource = requireNotNull(builder.configurationSource) { "A non-null value must be provided for configurationSource" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.CodeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeConfiguration(")
        append("codeConfigurationValues=$codeConfigurationValues,")
        append("configurationSource=$configurationSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeConfigurationValues?.hashCode() ?: 0
        result = 31 * result + (configurationSource.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeConfiguration

        if (codeConfigurationValues != other.codeConfigurationValues) return false
        if (configurationSource != other.configurationSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.CodeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a `apprunner.yaml` file in the source code repository (or ignoring the file if it exists).
         */
        public var codeConfigurationValues: aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues? = null
        /**
         * The source of the App Runner configuration. Values are interpreted as follows:
         * + `REPOSITORY` – App Runner reads configuration values from the `apprunner.yaml` file in the source code repository and ignores `CodeConfigurationValues`.
         * + `API` – App Runner uses configuration values provided in `CodeConfigurationValues` and ignores the `apprunner.yaml` file in the source code repository.
         */
        public var configurationSource: aws.sdk.kotlin.services.apprunner.model.ConfigurationSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.CodeConfiguration) : this() {
            this.codeConfigurationValues = x.codeConfigurationValues
            this.configurationSource = x.configurationSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.CodeConfiguration = CodeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues] inside the given [block]
         */
        public fun codeConfigurationValues(block: aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues.Builder.() -> kotlin.Unit) {
            this.codeConfigurationValues = aws.sdk.kotlin.services.apprunner.model.CodeConfigurationValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (configurationSource == null) configurationSource = ConfigurationSource.SdkUnknown("no value provided")
            return this
        }
    }
}
