// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about an App Runner automatic scaling configuration resource.
 *
 * This type contains limited information about an auto scaling configuration. It includes only identification information, without configuration details. It's returned by the ListAutoScalingConfigurations action. Complete configuration information is returned by the CreateAutoScalingConfiguration, DescribeAutoScalingConfiguration, and DeleteAutoScalingConfiguration actions using the AutoScalingConfiguration type.
 */
public class AutoScalingConfigurationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of this auto scaling configuration.
     */
    public val autoScalingConfigurationArn: kotlin.String? = builder.autoScalingConfigurationArn
    /**
     * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
     */
    public val autoScalingConfigurationName: kotlin.String? = builder.autoScalingConfigurationName
    /**
     * The revision of this auto scaling configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) with the same `AutoScalingConfigurationName`.
     */
    public val autoScalingConfigurationRevision: kotlin.Int = builder.autoScalingConfigurationRevision
    /**
     * The time when the auto scaling configuration was created. It's in Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of `true` indicates one or more services are associated. A value of `false` indicates no services are associated.
     */
    public val hasAssociatedService: kotlin.Boolean? = builder.hasAssociatedService
    /**
     * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that does not have an auto scaling configuration ARN specified during creation. Each account can have only one default `AutoScalingConfiguration` per region. The default `AutoScalingConfiguration` can be any revision under the same `AutoScalingConfigurationName`.
     */
    public val isDefault: kotlin.Boolean? = builder.isDefault
    /**
     * The current state of the auto scaling configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingConfigurationSummary(")
        append("autoScalingConfigurationArn=$autoScalingConfigurationArn,")
        append("autoScalingConfigurationName=$autoScalingConfigurationName,")
        append("autoScalingConfigurationRevision=$autoScalingConfigurationRevision,")
        append("createdAt=$createdAt,")
        append("hasAssociatedService=$hasAssociatedService,")
        append("isDefault=$isDefault,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (autoScalingConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (autoScalingConfigurationRevision)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (hasAssociatedService?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingConfigurationSummary

        if (autoScalingConfigurationArn != other.autoScalingConfigurationArn) return false
        if (autoScalingConfigurationName != other.autoScalingConfigurationName) return false
        if (autoScalingConfigurationRevision != other.autoScalingConfigurationRevision) return false
        if (createdAt != other.createdAt) return false
        if (hasAssociatedService != other.hasAssociatedService) return false
        if (isDefault != other.isDefault) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of this auto scaling configuration.
         */
        public var autoScalingConfigurationArn: kotlin.String? = null
        /**
         * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
         */
        public var autoScalingConfigurationName: kotlin.String? = null
        /**
         * The revision of this auto scaling configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) with the same `AutoScalingConfigurationName`.
         */
        public var autoScalingConfigurationRevision: kotlin.Int = 0
        /**
         * The time when the auto scaling configuration was created. It's in Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of `true` indicates one or more services are associated. A value of `false` indicates no services are associated.
         */
        public var hasAssociatedService: kotlin.Boolean? = null
        /**
         * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that does not have an auto scaling configuration ARN specified during creation. Each account can have only one default `AutoScalingConfiguration` per region. The default `AutoScalingConfiguration` can be any revision under the same `AutoScalingConfigurationName`.
         */
        public var isDefault: kotlin.Boolean? = null
        /**
         * The current state of the auto scaling configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary) : this() {
            this.autoScalingConfigurationArn = x.autoScalingConfigurationArn
            this.autoScalingConfigurationName = x.autoScalingConfigurationName
            this.autoScalingConfigurationRevision = x.autoScalingConfigurationRevision
            this.createdAt = x.createdAt
            this.hasAssociatedService = x.hasAssociatedService
            this.isDefault = x.isDefault
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationSummary = AutoScalingConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
