// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an App Runner automatic scaling configuration resource.
 *
 * A higher `MinSize` increases the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.
 *
 * A lower `MaxSize` controls your cost. The tradeoff is lower responsiveness during peak demand.
 *
 * Multiple revisions of a configuration might have the same `AutoScalingConfigurationName` and different `AutoScalingConfigurationRevision` values.
 */
public class AutoScalingConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of this auto scaling configuration.
     */
    public val autoScalingConfigurationArn: kotlin.String? = builder.autoScalingConfigurationArn
    /**
     * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
     */
    public val autoScalingConfigurationName: kotlin.String? = builder.autoScalingConfigurationName
    /**
     * The revision of this auto scaling configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `AutoScalingConfigurationName`.
     */
    public val autoScalingConfigurationRevision: kotlin.Int? = builder.autoScalingConfigurationRevision
    /**
     * The time when the auto scaling configuration was created. It's in Unix time stamp format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The time when the auto scaling configuration was deleted. It's in Unix time stamp format.
     */
    public val deletedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedAt
    /**
     * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of `true` indicates one or more services are associated. A value of `false` indicates no services are associated.
     */
    public val hasAssociatedService: kotlin.Boolean? = builder.hasAssociatedService
    /**
     * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that does not have an auto scaling configuration ARN specified during creation. Each account can have only one default `AutoScalingConfiguration` per region. The default `AutoScalingConfiguration` can be any revision under the same `AutoScalingConfigurationName`.
     */
    public val isDefault: kotlin.Boolean? = builder.isDefault
    /**
     * It's set to `true` for the configuration with the highest `Revision` among all configurations that share the same `AutoScalingConfigurationName`. It's set to `false` otherwise.
     */
    public val latest: kotlin.Boolean? = builder.latest
    /**
     * The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.
     */
    public val maxConcurrency: kotlin.Int? = builder.maxConcurrency
    /**
     * The maximum number of instances that a service scales up to. At most `MaxSize` instances actively serve traffic for your service.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum number of instances that App Runner provisions for a service. The service always has at least `MinSize` provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.
     *
     * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The current state of the auto scaling configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
     */
    public val status: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingConfiguration(")
        append("autoScalingConfigurationArn=$autoScalingConfigurationArn,")
        append("autoScalingConfigurationName=$autoScalingConfigurationName,")
        append("autoScalingConfigurationRevision=$autoScalingConfigurationRevision,")
        append("createdAt=$createdAt,")
        append("deletedAt=$deletedAt,")
        append("hasAssociatedService=$hasAssociatedService,")
        append("isDefault=$isDefault,")
        append("latest=$latest,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (autoScalingConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (autoScalingConfigurationRevision ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deletedAt?.hashCode() ?: 0)
        result = 31 * result + (hasAssociatedService?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (latest?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingConfiguration

        if (autoScalingConfigurationArn != other.autoScalingConfigurationArn) return false
        if (autoScalingConfigurationName != other.autoScalingConfigurationName) return false
        if (autoScalingConfigurationRevision != other.autoScalingConfigurationRevision) return false
        if (createdAt != other.createdAt) return false
        if (deletedAt != other.deletedAt) return false
        if (hasAssociatedService != other.hasAssociatedService) return false
        if (isDefault != other.isDefault) return false
        if (latest != other.latest) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of this auto scaling configuration.
         */
        public var autoScalingConfigurationArn: kotlin.String? = null
        /**
         * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
         */
        public var autoScalingConfigurationName: kotlin.String? = null
        /**
         * The revision of this auto scaling configuration. It's unique among all the active configurations (`"Status": "ACTIVE"`) that share the same `AutoScalingConfigurationName`.
         */
        public var autoScalingConfigurationRevision: kotlin.Int? = null
        /**
         * The time when the auto scaling configuration was created. It's in Unix time stamp format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the auto scaling configuration was deleted. It's in Unix time stamp format.
         */
        public var deletedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of `true` indicates one or more services are associated. A value of `false` indicates no services are associated.
         */
        public var hasAssociatedService: kotlin.Boolean? = null
        /**
         * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that does not have an auto scaling configuration ARN specified during creation. Each account can have only one default `AutoScalingConfiguration` per region. The default `AutoScalingConfiguration` can be any revision under the same `AutoScalingConfigurationName`.
         */
        public var isDefault: kotlin.Boolean? = null
        /**
         * It's set to `true` for the configuration with the highest `Revision` among all configurations that share the same `AutoScalingConfigurationName`. It's set to `false` otherwise.
         */
        public var latest: kotlin.Boolean? = null
        /**
         * The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.
         */
        public var maxConcurrency: kotlin.Int? = null
        /**
         * The maximum number of instances that a service scales up to. At most `MaxSize` instances actively serve traffic for your service.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum number of instances that App Runner provisions for a service. The service always has at least `MinSize` provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.
         *
         * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The current state of the auto scaling configuration. If the status of a configuration revision is `INACTIVE`, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.
         */
        public var status: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfigurationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.AutoScalingConfiguration) : this() {
            this.autoScalingConfigurationArn = x.autoScalingConfigurationArn
            this.autoScalingConfigurationName = x.autoScalingConfigurationName
            this.autoScalingConfigurationRevision = x.autoScalingConfigurationRevision
            this.createdAt = x.createdAt
            this.deletedAt = x.deletedAt
            this.hasAssociatedService = x.hasAssociatedService
            this.isDefault = x.isDefault
            this.latest = x.latest
            this.maxConcurrency = x.maxConcurrency
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.AutoScalingConfiguration = AutoScalingConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
