// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner.model



/**
 * Describes resources needed to authenticate access to some source repositories. The specific resource depends on the repository provider.
 */
public class AuthenticationConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).
     */
    public val accessRoleArn: kotlin.String? = builder.accessRoleArn
    /**
     * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.
     */
    public val connectionArn: kotlin.String? = builder.connectionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticationConfiguration(")
        append("accessRoleArn=$accessRoleArn,")
        append("connectionArn=$connectionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRoleArn?.hashCode() ?: 0
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticationConfiguration

        if (accessRoleArn != other.accessRoleArn) return false
        if (connectionArn != other.connectionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).
         */
        public var accessRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.
         */
        public var connectionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration) : this() {
            this.accessRoleArn = x.accessRoleArn
            this.connectionArn = x.connectionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apprunner.model.AuthenticationConfiguration = AuthenticationConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
