// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apprunner

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.apprunner.auth.AppRunnerAuthSchemeProvider
import aws.sdk.kotlin.services.apprunner.auth.DefaultAppRunnerAuthSchemeProvider
import aws.sdk.kotlin.services.apprunner.endpoints.AppRunnerEndpointParameters
import aws.sdk.kotlin.services.apprunner.endpoints.AppRunnerEndpointProvider
import aws.sdk.kotlin.services.apprunner.endpoints.DefaultAppRunnerEndpointProvider
import aws.sdk.kotlin.services.apprunner.model.AssociateCustomDomainRequest
import aws.sdk.kotlin.services.apprunner.model.AssociateCustomDomainResponse
import aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.CreateAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.CreateConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.CreateConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.CreateObservabilityConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.CreateServiceRequest
import aws.sdk.kotlin.services.apprunner.model.CreateServiceResponse
import aws.sdk.kotlin.services.apprunner.model.CreateVpcConnectorRequest
import aws.sdk.kotlin.services.apprunner.model.CreateVpcConnectorResponse
import aws.sdk.kotlin.services.apprunner.model.CreateVpcIngressConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.CreateVpcIngressConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteObservabilityConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteObservabilityConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteServiceRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteServiceResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteVpcConnectorRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteVpcConnectorResponse
import aws.sdk.kotlin.services.apprunner.model.DeleteVpcIngressConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.DeleteVpcIngressConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeCustomDomainsResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeObservabilityConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeObservabilityConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeServiceRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeServiceResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeVpcConnectorRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeVpcConnectorResponse
import aws.sdk.kotlin.services.apprunner.model.DescribeVpcIngressConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.DescribeVpcIngressConnectionResponse
import aws.sdk.kotlin.services.apprunner.model.DisassociateCustomDomainRequest
import aws.sdk.kotlin.services.apprunner.model.DisassociateCustomDomainResponse
import aws.sdk.kotlin.services.apprunner.model.ListAutoScalingConfigurationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListAutoScalingConfigurationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListConnectionsRequest
import aws.sdk.kotlin.services.apprunner.model.ListConnectionsResponse
import aws.sdk.kotlin.services.apprunner.model.ListObservabilityConfigurationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListObservabilityConfigurationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListOperationsRequest
import aws.sdk.kotlin.services.apprunner.model.ListOperationsResponse
import aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.ListServicesRequest
import aws.sdk.kotlin.services.apprunner.model.ListServicesResponse
import aws.sdk.kotlin.services.apprunner.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.apprunner.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.apprunner.model.ListVpcConnectorsRequest
import aws.sdk.kotlin.services.apprunner.model.ListVpcConnectorsResponse
import aws.sdk.kotlin.services.apprunner.model.ListVpcIngressConnectionsRequest
import aws.sdk.kotlin.services.apprunner.model.ListVpcIngressConnectionsResponse
import aws.sdk.kotlin.services.apprunner.model.PauseServiceRequest
import aws.sdk.kotlin.services.apprunner.model.PauseServiceResponse
import aws.sdk.kotlin.services.apprunner.model.ResumeServiceRequest
import aws.sdk.kotlin.services.apprunner.model.ResumeServiceResponse
import aws.sdk.kotlin.services.apprunner.model.StartDeploymentRequest
import aws.sdk.kotlin.services.apprunner.model.StartDeploymentResponse
import aws.sdk.kotlin.services.apprunner.model.TagResourceRequest
import aws.sdk.kotlin.services.apprunner.model.TagResourceResponse
import aws.sdk.kotlin.services.apprunner.model.UntagResourceRequest
import aws.sdk.kotlin.services.apprunner.model.UntagResourceResponse
import aws.sdk.kotlin.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
import aws.sdk.kotlin.services.apprunner.model.UpdateDefaultAutoScalingConfigurationResponse
import aws.sdk.kotlin.services.apprunner.model.UpdateServiceRequest
import aws.sdk.kotlin.services.apprunner.model.UpdateServiceResponse
import aws.sdk.kotlin.services.apprunner.model.UpdateVpcIngressConnectionRequest
import aws.sdk.kotlin.services.apprunner.model.UpdateVpcIngressConnectionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppRunner"
public const val SdkVersion: String = "1.0.20"
public const val ServiceApiVersion: String = "2020-05-15"

/**
 * # App Runner
 * App Runner is an application service that provides a fast, simple, and cost-effective way to go directly from an existing container image or source code to a running service in the Amazon Web Services Cloud in seconds. You don't need to learn new technologies, decide which compute service to use, or understand how to provision and configure Amazon Web Services resources.
 *
 * App Runner connects directly to your container registry or source code repository. It provides an automatic delivery pipeline with fully managed operations, high performance, scalability, and security.
 *
 * For more information about App Runner, see the [App Runner Developer Guide](https://docs.aws.amazon.com/apprunner/latest/dg/). For release information, see the [App Runner Release Notes](https://docs.aws.amazon.com/apprunner/latest/relnotes/).
 *
 *  To install the Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools that you can use to access the API, see [Tools for Amazon Web Services](http://aws.amazon.com/tools/).
 *
 * **Endpoints**
 *
 * For a list of Region-specific endpoints that App Runner supports, see [App Runner endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/apprunner.html) in the *Amazon Web Services General Reference*.
 */
public interface AppRunnerClient : SdkClient {
    /**
     * AppRunnerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppRunnerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppRunner",
                "APPRUNNER",
                "apprunner",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppRunnerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppRunnerClient = DefaultAppRunnerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppRunnerEndpointProvider = builder.endpointProvider ?: DefaultAppRunnerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppRunnerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppRunnerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppRunner"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppRunnerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppRunnerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associate your own domain name with the App Runner subdomain URL of your App Runner service.
     *
     * After you call `AssociateCustomDomain` and receive a successful response, use the information in the CustomDomain record that's returned to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain and one or more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name that you associated. App Runner tracks domain validity in a certificate stored in [AWS Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide).
     */
    public suspend fun associateCustomDomain(input: AssociateCustomDomainRequest): AssociateCustomDomainResponse

    /**
     * Create an App Runner automatic scaling configuration resource. App Runner requires this resource when you create or update App Runner services and you require non-default auto scaling settings. You can share an auto scaling configuration across multiple services.
     *
     * Create multiple revisions of a configuration by calling this action multiple times using the same `AutoScalingConfigurationName`. The call returns incremental `AutoScalingConfigurationRevision` values. When you create a service and configure an auto scaling configuration resource, the service uses the latest active revision of the auto scaling configuration by default. You can optionally configure the service to use a specific revision.
     *
     * Configure a higher `MinSize` to increase the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.
     *
     * Configure a lower `MaxSize` to control your cost. The tradeoff is lower responsiveness during peak demand.
     */
    public suspend fun createAutoScalingConfiguration(input: CreateAutoScalingConfigurationRequest): CreateAutoScalingConfigurationResponse

    /**
     * Create an App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from certain third-party providers. You can share a connection across multiple services.
     *
     * A connection resource is needed to access GitHub and Bitbucket repositories. Both require a user interface approval process through the App Runner console before you can use the connection.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Create an App Runner observability configuration resource. App Runner requires this resource when you create or update App Runner services and you want to enable non-default observability features. You can share an observability configuration across multiple services.
     *
     * Create multiple revisions of a configuration by calling this action multiple times using the same `ObservabilityConfigurationName`. The call returns incremental `ObservabilityConfigurationRevision` values. When you create a service and configure an observability configuration resource, the service uses the latest active revision of the observability configuration by default. You can optionally configure the service to use a specific revision.
     *
     * The observability configuration resource is designed to configure multiple features (currently one feature, tracing). This action takes optional parameters that describe the configuration of these features (currently one parameter, `TraceConfiguration`). If you don't specify a feature parameter, App Runner doesn't enable the feature.
     */
    public suspend fun createObservabilityConfiguration(input: CreateObservabilityConfigurationRequest): CreateObservabilityConfigurationResponse

    /**
     * Create an App Runner service. After the service is created, the action also automatically starts a deployment.
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the [ListOperations](https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html) call to track the operation's progress.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Create an App Runner VPC connector resource. App Runner requires this resource when you want to associate your App Runner service to a custom Amazon Virtual Private Cloud (Amazon VPC).
     */
    public suspend fun createVpcConnector(input: CreateVpcConnectorRequest): CreateVpcConnectorResponse

    /**
     * Create an App Runner VPC Ingress Connection resource. App Runner requires this resource when you want to associate your App Runner service with an Amazon VPC endpoint.
     */
    public suspend fun createVpcIngressConnection(input: CreateVpcIngressConnectionRequest): CreateVpcIngressConnectionResponse

    /**
     * Delete an App Runner automatic scaling configuration resource. You can delete a top level auto scaling configuration, a specific revision of one, or all revisions associated with the top level configuration. You can't delete the default auto scaling configuration or a configuration that's used by one or more App Runner services.
     */
    public suspend fun deleteAutoScalingConfiguration(input: DeleteAutoScalingConfigurationRequest): DeleteAutoScalingConfigurationResponse

    /**
     * Delete an App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the `DeleteConnection` action fails.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Delete an App Runner observability configuration resource. You can delete a specific revision or the latest active revision. You can't delete a configuration that's used by one or more App Runner services.
     */
    public suspend fun deleteObservabilityConfiguration(input: DeleteObservabilityConfigurationRequest): DeleteObservabilityConfigurationResponse

    /**
     * Delete an App Runner service.
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
     *
     * Make sure that you don't have any active VPCIngressConnections associated with the service you want to delete.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Delete an App Runner VPC connector resource. You can't delete a connector that's used by one or more App Runner services.
     */
    public suspend fun deleteVpcConnector(input: DeleteVpcConnectorRequest): DeleteVpcConnectorResponse

    /**
     * Delete an App Runner VPC Ingress Connection resource that's associated with an App Runner service. The VPC Ingress Connection must be in one of the following states to be deleted:
     * + `AVAILABLE`
     * + `FAILED_CREATION`
     * + `FAILED_UPDATE`
     * + `FAILED_DELETION`
     */
    public suspend fun deleteVpcIngressConnection(input: DeleteVpcIngressConnectionRequest): DeleteVpcIngressConnectionResponse

    /**
     * Return a full description of an App Runner automatic scaling configuration resource.
     */
    public suspend fun describeAutoScalingConfiguration(input: DescribeAutoScalingConfigurationRequest): DescribeAutoScalingConfigurationResponse

    /**
     * Return a description of custom domain names that are associated with an App Runner service.
     */
    public suspend fun describeCustomDomains(input: DescribeCustomDomainsRequest): DescribeCustomDomainsResponse

    /**
     * Return a full description of an App Runner observability configuration resource.
     */
    public suspend fun describeObservabilityConfiguration(input: DescribeObservabilityConfigurationRequest): DescribeObservabilityConfigurationResponse

    /**
     * Return a full description of an App Runner service.
     */
    public suspend fun describeService(input: DescribeServiceRequest): DescribeServiceResponse

    /**
     * Return a description of an App Runner VPC connector resource.
     */
    public suspend fun describeVpcConnector(input: DescribeVpcConnectorRequest): DescribeVpcConnectorResponse

    /**
     * Return a full description of an App Runner VPC Ingress Connection resource.
     */
    public suspend fun describeVpcIngressConnection(input: DescribeVpcIngressConnectionRequest): DescribeVpcIngressConnectionResponse

    /**
     * Disassociate a custom domain name from an App Runner service.
     *
     * Certificates tracking domain validity are associated with a custom domain and are stored in [AWS Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide). These certificates aren't deleted as part of this action. App Runner delays certificate deletion for 30 days after a domain is disassociated from your service.
     */
    public suspend fun disassociateCustomDomain(input: DisassociateCustomDomainRequest): DisassociateCustomDomainResponse

    /**
     * Returns a list of active App Runner automatic scaling configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
     *
     * To retrieve a full description of a particular configuration revision, call and provide one of the ARNs returned by `ListAutoScalingConfigurations`.
     */
    public suspend fun listAutoScalingConfigurations(input: ListAutoScalingConfigurationsRequest = ListAutoScalingConfigurationsRequest { }): ListAutoScalingConfigurationsResponse

    /**
     * Returns a list of App Runner connections that are associated with your Amazon Web Services account.
     */
    public suspend fun listConnections(input: ListConnectionsRequest = ListConnectionsRequest { }): ListConnectionsResponse

    /**
     * Returns a list of active App Runner observability configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
     *
     * To retrieve a full description of a particular configuration revision, call and provide one of the ARNs returned by `ListObservabilityConfigurations`.
     */
    public suspend fun listObservabilityConfigurations(input: ListObservabilityConfigurationsRequest = ListObservabilityConfigurationsRequest { }): ListObservabilityConfigurationsResponse

    /**
     * Return a list of operations that occurred on an App Runner service.
     *
     * The resulting list of OperationSummary objects is sorted in reverse chronological order. The first object on the list represents the last started operation.
     */
    public suspend fun listOperations(input: ListOperationsRequest): ListOperationsResponse

    /**
     * Returns a list of running App Runner services in your Amazon Web Services account.
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest { }): ListServicesResponse

    /**
     * Returns a list of the associated App Runner services using an auto scaling configuration.
     */
    public suspend fun listServicesForAutoScalingConfiguration(input: ListServicesForAutoScalingConfigurationRequest): ListServicesForAutoScalingConfigurationResponse

    /**
     * List tags that are associated with for an App Runner resource. The response contains a list of tag key-value pairs.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of App Runner VPC connectors in your Amazon Web Services account.
     */
    public suspend fun listVpcConnectors(input: ListVpcConnectorsRequest = ListVpcConnectorsRequest { }): ListVpcConnectorsResponse

    /**
     * Return a list of App Runner VPC Ingress Connections in your Amazon Web Services account.
     */
    public suspend fun listVpcIngressConnections(input: ListVpcIngressConnectionsRequest = ListVpcIngressConnectionsRequest { }): ListVpcIngressConnectionsResponse

    /**
     * Pause an active App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is removed).
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
     */
    public suspend fun pauseService(input: PauseServiceRequest): PauseServiceResponse

    /**
     * Resume an active App Runner service. App Runner provisions compute capacity for the service.
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
     */
    public suspend fun resumeService(input: ResumeServiceRequest): ResumeServiceResponse

    /**
     * Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner service.
     *
     * For a source code repository, App Runner retrieves the commit and builds a Docker image. For a source image repository, App Runner retrieves the latest Docker image. In both cases, App Runner then deploys the new image to your service and starts a new container instance.
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
     */
    public suspend fun startDeployment(input: StartDeploymentRequest): StartDeploymentResponse

    /**
     * Add tags to, or update the tag values of, an App Runner resource. A tag is a key-value pair.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove tags from an App Runner resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update an auto scaling configuration to be the default. The existing default auto scaling configuration will be set to non-default automatically.
     */
    public suspend fun updateDefaultAutoScalingConfiguration(input: UpdateDefaultAutoScalingConfigurationRequest): UpdateDefaultAutoScalingConfigurationResponse

    /**
     * Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service. These can be set only when you create the service.
     *
     * To update the tags applied to your service, use the separate actions TagResource and UntagResource.
     *
     * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse

    /**
     * Update an existing App Runner VPC Ingress Connection resource. The VPC Ingress Connection must be in one of the following states to be updated:
     * +  AVAILABLE
     * +  FAILED_CREATION
     * +  FAILED_UPDATE
     */
    public suspend fun updateVpcIngressConnection(input: UpdateVpcIngressConnectionRequest): UpdateVpcIngressConnectionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppRunnerClient.withConfig(block: AppRunnerClient.Config.Builder.() -> Unit): AppRunnerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppRunnerClient(newConfig)
}

/**
 * Associate your own domain name with the App Runner subdomain URL of your App Runner service.
 *
 * After you call `AssociateCustomDomain` and receive a successful response, use the information in the CustomDomain record that's returned to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain and one or more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name that you associated. App Runner tracks domain validity in a certificate stored in [AWS Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide).
 */
public suspend inline fun AppRunnerClient.associateCustomDomain(crossinline block: AssociateCustomDomainRequest.Builder.() -> Unit): AssociateCustomDomainResponse = associateCustomDomain(AssociateCustomDomainRequest.Builder().apply(block).build())

/**
 * Create an App Runner automatic scaling configuration resource. App Runner requires this resource when you create or update App Runner services and you require non-default auto scaling settings. You can share an auto scaling configuration across multiple services.
 *
 * Create multiple revisions of a configuration by calling this action multiple times using the same `AutoScalingConfigurationName`. The call returns incremental `AutoScalingConfigurationRevision` values. When you create a service and configure an auto scaling configuration resource, the service uses the latest active revision of the auto scaling configuration by default. You can optionally configure the service to use a specific revision.
 *
 * Configure a higher `MinSize` to increase the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.
 *
 * Configure a lower `MaxSize` to control your cost. The tradeoff is lower responsiveness during peak demand.
 */
public suspend inline fun AppRunnerClient.createAutoScalingConfiguration(crossinline block: CreateAutoScalingConfigurationRequest.Builder.() -> Unit): CreateAutoScalingConfigurationResponse = createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * Create an App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from certain third-party providers. You can share a connection across multiple services.
 *
 * A connection resource is needed to access GitHub and Bitbucket repositories. Both require a user interface approval process through the App Runner console before you can use the connection.
 */
public suspend inline fun AppRunnerClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Create an App Runner observability configuration resource. App Runner requires this resource when you create or update App Runner services and you want to enable non-default observability features. You can share an observability configuration across multiple services.
 *
 * Create multiple revisions of a configuration by calling this action multiple times using the same `ObservabilityConfigurationName`. The call returns incremental `ObservabilityConfigurationRevision` values. When you create a service and configure an observability configuration resource, the service uses the latest active revision of the observability configuration by default. You can optionally configure the service to use a specific revision.
 *
 * The observability configuration resource is designed to configure multiple features (currently one feature, tracing). This action takes optional parameters that describe the configuration of these features (currently one parameter, `TraceConfiguration`). If you don't specify a feature parameter, App Runner doesn't enable the feature.
 */
public suspend inline fun AppRunnerClient.createObservabilityConfiguration(crossinline block: CreateObservabilityConfigurationRequest.Builder.() -> Unit): CreateObservabilityConfigurationResponse = createObservabilityConfiguration(CreateObservabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Create an App Runner service. After the service is created, the action also automatically starts a deployment.
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the [ListOperations](https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html) call to track the operation's progress.
 */
public suspend inline fun AppRunnerClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Create an App Runner VPC connector resource. App Runner requires this resource when you want to associate your App Runner service to a custom Amazon Virtual Private Cloud (Amazon VPC).
 */
public suspend inline fun AppRunnerClient.createVpcConnector(crossinline block: CreateVpcConnectorRequest.Builder.() -> Unit): CreateVpcConnectorResponse = createVpcConnector(CreateVpcConnectorRequest.Builder().apply(block).build())

/**
 * Create an App Runner VPC Ingress Connection resource. App Runner requires this resource when you want to associate your App Runner service with an Amazon VPC endpoint.
 */
public suspend inline fun AppRunnerClient.createVpcIngressConnection(crossinline block: CreateVpcIngressConnectionRequest.Builder.() -> Unit): CreateVpcIngressConnectionResponse = createVpcIngressConnection(CreateVpcIngressConnectionRequest.Builder().apply(block).build())

/**
 * Delete an App Runner automatic scaling configuration resource. You can delete a top level auto scaling configuration, a specific revision of one, or all revisions associated with the top level configuration. You can't delete the default auto scaling configuration or a configuration that's used by one or more App Runner services.
 */
public suspend inline fun AppRunnerClient.deleteAutoScalingConfiguration(crossinline block: DeleteAutoScalingConfigurationRequest.Builder.() -> Unit): DeleteAutoScalingConfigurationResponse = deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * Delete an App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the `DeleteConnection` action fails.
 */
public suspend inline fun AppRunnerClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * Delete an App Runner observability configuration resource. You can delete a specific revision or the latest active revision. You can't delete a configuration that's used by one or more App Runner services.
 */
public suspend inline fun AppRunnerClient.deleteObservabilityConfiguration(crossinline block: DeleteObservabilityConfigurationRequest.Builder.() -> Unit): DeleteObservabilityConfigurationResponse = deleteObservabilityConfiguration(DeleteObservabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Delete an App Runner service.
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
 *
 * Make sure that you don't have any active VPCIngressConnections associated with the service you want to delete.
 */
public suspend inline fun AppRunnerClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Delete an App Runner VPC connector resource. You can't delete a connector that's used by one or more App Runner services.
 */
public suspend inline fun AppRunnerClient.deleteVpcConnector(crossinline block: DeleteVpcConnectorRequest.Builder.() -> Unit): DeleteVpcConnectorResponse = deleteVpcConnector(DeleteVpcConnectorRequest.Builder().apply(block).build())

/**
 * Delete an App Runner VPC Ingress Connection resource that's associated with an App Runner service. The VPC Ingress Connection must be in one of the following states to be deleted:
 * + `AVAILABLE`
 * + `FAILED_CREATION`
 * + `FAILED_UPDATE`
 * + `FAILED_DELETION`
 */
public suspend inline fun AppRunnerClient.deleteVpcIngressConnection(crossinline block: DeleteVpcIngressConnectionRequest.Builder.() -> Unit): DeleteVpcIngressConnectionResponse = deleteVpcIngressConnection(DeleteVpcIngressConnectionRequest.Builder().apply(block).build())

/**
 * Return a full description of an App Runner automatic scaling configuration resource.
 */
public suspend inline fun AppRunnerClient.describeAutoScalingConfiguration(crossinline block: DescribeAutoScalingConfigurationRequest.Builder.() -> Unit): DescribeAutoScalingConfigurationResponse = describeAutoScalingConfiguration(DescribeAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * Return a description of custom domain names that are associated with an App Runner service.
 */
public suspend inline fun AppRunnerClient.describeCustomDomains(crossinline block: DescribeCustomDomainsRequest.Builder.() -> Unit): DescribeCustomDomainsResponse = describeCustomDomains(DescribeCustomDomainsRequest.Builder().apply(block).build())

/**
 * Return a full description of an App Runner observability configuration resource.
 */
public suspend inline fun AppRunnerClient.describeObservabilityConfiguration(crossinline block: DescribeObservabilityConfigurationRequest.Builder.() -> Unit): DescribeObservabilityConfigurationResponse = describeObservabilityConfiguration(DescribeObservabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Return a full description of an App Runner service.
 */
public suspend inline fun AppRunnerClient.describeService(crossinline block: DescribeServiceRequest.Builder.() -> Unit): DescribeServiceResponse = describeService(DescribeServiceRequest.Builder().apply(block).build())

/**
 * Return a description of an App Runner VPC connector resource.
 */
public suspend inline fun AppRunnerClient.describeVpcConnector(crossinline block: DescribeVpcConnectorRequest.Builder.() -> Unit): DescribeVpcConnectorResponse = describeVpcConnector(DescribeVpcConnectorRequest.Builder().apply(block).build())

/**
 * Return a full description of an App Runner VPC Ingress Connection resource.
 */
public suspend inline fun AppRunnerClient.describeVpcIngressConnection(crossinline block: DescribeVpcIngressConnectionRequest.Builder.() -> Unit): DescribeVpcIngressConnectionResponse = describeVpcIngressConnection(DescribeVpcIngressConnectionRequest.Builder().apply(block).build())

/**
 * Disassociate a custom domain name from an App Runner service.
 *
 * Certificates tracking domain validity are associated with a custom domain and are stored in [AWS Certificate Manager (ACM)](https://docs.aws.amazon.com/acm/latest/userguide). These certificates aren't deleted as part of this action. App Runner delays certificate deletion for 30 days after a domain is disassociated from your service.
 */
public suspend inline fun AppRunnerClient.disassociateCustomDomain(crossinline block: DisassociateCustomDomainRequest.Builder.() -> Unit): DisassociateCustomDomainResponse = disassociateCustomDomain(DisassociateCustomDomainRequest.Builder().apply(block).build())

/**
 * Returns a list of active App Runner automatic scaling configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
 *
 * To retrieve a full description of a particular configuration revision, call and provide one of the ARNs returned by `ListAutoScalingConfigurations`.
 */
public suspend inline fun AppRunnerClient.listAutoScalingConfigurations(crossinline block: ListAutoScalingConfigurationsRequest.Builder.() -> Unit): ListAutoScalingConfigurationsResponse = listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of App Runner connections that are associated with your Amazon Web Services account.
 */
public suspend inline fun AppRunnerClient.listConnections(crossinline block: ListConnectionsRequest.Builder.() -> Unit): ListConnectionsResponse = listConnections(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Returns a list of active App Runner observability configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
 *
 * To retrieve a full description of a particular configuration revision, call and provide one of the ARNs returned by `ListObservabilityConfigurations`.
 */
public suspend inline fun AppRunnerClient.listObservabilityConfigurations(crossinline block: ListObservabilityConfigurationsRequest.Builder.() -> Unit): ListObservabilityConfigurationsResponse = listObservabilityConfigurations(ListObservabilityConfigurationsRequest.Builder().apply(block).build())

/**
 * Return a list of operations that occurred on an App Runner service.
 *
 * The resulting list of OperationSummary objects is sorted in reverse chronological order. The first object on the list represents the last started operation.
 */
public suspend inline fun AppRunnerClient.listOperations(crossinline block: ListOperationsRequest.Builder.() -> Unit): ListOperationsResponse = listOperations(ListOperationsRequest.Builder().apply(block).build())

/**
 * Returns a list of running App Runner services in your Amazon Web Services account.
 */
public suspend inline fun AppRunnerClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Returns a list of the associated App Runner services using an auto scaling configuration.
 */
public suspend inline fun AppRunnerClient.listServicesForAutoScalingConfiguration(crossinline block: ListServicesForAutoScalingConfigurationRequest.Builder.() -> Unit): ListServicesForAutoScalingConfigurationResponse = listServicesForAutoScalingConfiguration(ListServicesForAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * List tags that are associated with for an App Runner resource. The response contains a list of tag key-value pairs.
 */
public suspend inline fun AppRunnerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of App Runner VPC connectors in your Amazon Web Services account.
 */
public suspend inline fun AppRunnerClient.listVpcConnectors(crossinline block: ListVpcConnectorsRequest.Builder.() -> Unit): ListVpcConnectorsResponse = listVpcConnectors(ListVpcConnectorsRequest.Builder().apply(block).build())

/**
 * Return a list of App Runner VPC Ingress Connections in your Amazon Web Services account.
 */
public suspend inline fun AppRunnerClient.listVpcIngressConnections(crossinline block: ListVpcIngressConnectionsRequest.Builder.() -> Unit): ListVpcIngressConnectionsResponse = listVpcIngressConnections(ListVpcIngressConnectionsRequest.Builder().apply(block).build())

/**
 * Pause an active App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is removed).
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
 */
public suspend inline fun AppRunnerClient.pauseService(crossinline block: PauseServiceRequest.Builder.() -> Unit): PauseServiceResponse = pauseService(PauseServiceRequest.Builder().apply(block).build())

/**
 * Resume an active App Runner service. App Runner provisions compute capacity for the service.
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
 */
public suspend inline fun AppRunnerClient.resumeService(crossinline block: ResumeServiceRequest.Builder.() -> Unit): ResumeServiceResponse = resumeService(ResumeServiceRequest.Builder().apply(block).build())

/**
 * Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner service.
 *
 * For a source code repository, App Runner retrieves the commit and builds a Docker image. For a source image repository, App Runner retrieves the latest Docker image. In both cases, App Runner then deploys the new image to your service and starts a new container instance.
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
 */
public suspend inline fun AppRunnerClient.startDeployment(crossinline block: StartDeploymentRequest.Builder.() -> Unit): StartDeploymentResponse = startDeployment(StartDeploymentRequest.Builder().apply(block).build())

/**
 * Add tags to, or update the tag values of, an App Runner resource. A tag is a key-value pair.
 */
public suspend inline fun AppRunnerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove tags from an App Runner resource.
 */
public suspend inline fun AppRunnerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update an auto scaling configuration to be the default. The existing default auto scaling configuration will be set to non-default automatically.
 */
public suspend inline fun AppRunnerClient.updateDefaultAutoScalingConfiguration(crossinline block: UpdateDefaultAutoScalingConfigurationRequest.Builder.() -> Unit): UpdateDefaultAutoScalingConfigurationResponse = updateDefaultAutoScalingConfiguration(UpdateDefaultAutoScalingConfigurationRequest.Builder().apply(block).build())

/**
 * Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service. These can be set only when you create the service.
 *
 * To update the tags applied to your service, use the separate actions TagResource and UntagResource.
 *
 * This is an asynchronous operation. On a successful call, you can use the returned `OperationId` and the ListOperations call to track the operation's progress.
 */
public suspend inline fun AppRunnerClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())

/**
 * Update an existing App Runner VPC Ingress Connection resource. The VPC Ingress Connection must be in one of the following states to be updated:
 * +  AVAILABLE
 * +  FAILED_CREATION
 * +  FAILED_UPDATE
 */
public suspend inline fun AppRunnerClient.updateVpcIngressConnection(crossinline block: UpdateVpcIngressConnectionRequest.Builder.() -> Unit): UpdateVpcIngressConnectionResponse = updateVpcIngressConnection(UpdateVpcIngressConnectionRequest.Builder().apply(block).build())
