// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appmesh.model.AppMeshException
import aws.sdk.kotlin.services.appmesh.model.DeleteVirtualRouterResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer


internal class DeleteVirtualRouterOperationDeserializer: HttpDeserialize<DeleteVirtualRouterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteVirtualRouterResponse {
        if (!response.status.isSuccess()) {
            throwDeleteVirtualRouterError(context, response)
        }
        val builder = DeleteVirtualRouterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteVirtualRouterOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private fun deserializeDeleteVirtualRouterOperationBody(builder: DeleteVirtualRouterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    builder.virtualRouter = deserializeVirtualRouterDataDocument(deserializer)
}

private suspend fun throwDeleteVirtualRouterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw AppMeshException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
