// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the Transport Layer Security (TLS) properties for a listener.
 */
class ListenerTls private constructor(builder: Builder) {
    /**
     * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
     */
    val certificate: aws.sdk.kotlin.services.appmesh.model.ListenerTlsCertificate? = builder.certificate
    /**
     * Specify one of the following modes.
     * <b/>STRICT – Listener only accepts connections with TLS
     * enabled.
     * <b/>PERMISSIVE – Listener accepts connections with or
     * without TLS enabled.
     * <b/>DISABLED – Listener only accepts connections without
     * TLS.
     */
    val mode: aws.sdk.kotlin.services.appmesh.model.ListenerTlsMode? = builder.mode
    /**
     * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
     */
    val validation: aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext? = builder.validation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.ListenerTls = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListenerTls(")
        append("certificate=$certificate,")
        append("mode=$mode,")
        append("validation=$validation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListenerTls

        if (certificate != other.certificate) return false
        if (mode != other.mode) return false
        if (validation != other.validation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.ListenerTls = Builder(this).apply(block).build()

    class Builder {
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         */
        var certificate: aws.sdk.kotlin.services.appmesh.model.ListenerTlsCertificate? = null
        /**
         * Specify one of the following modes.
         * <b/>STRICT – Listener only accepts connections with TLS
         * enabled.
         * <b/>PERMISSIVE – Listener accepts connections with or
         * without TLS enabled.
         * <b/>DISABLED – Listener only accepts connections without
         * TLS.
         */
        var mode: aws.sdk.kotlin.services.appmesh.model.ListenerTlsMode? = null
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         */
        var validation: aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.ListenerTls) : this() {
            this.certificate = x.certificate
            this.mode = x.mode
            this.validation = x.validation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.ListenerTls = ListenerTls(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext] inside the given [block]
         */
        fun validation(block: aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext.Builder.() -> kotlin.Unit) {
            this.validation = aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext.invoke(block)
        }
    }
}
