// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the requirements for a route to match HTTP requests for a
 * virtual router.
 */
class HttpRouteMatch private constructor(builder: Builder) {
    /**
     * The client request headers to match on.
     */
    val headers: List<HttpRouteHeader>? = builder.headers
    /**
     * The client request method to match on. Specify only one.
     */
    val method: aws.sdk.kotlin.services.appmesh.model.HttpMethod? = builder.method
    /**
     * The client request path to match on.
     */
    val path: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch? = builder.path
    /**
     * Specifies the path to match requests with. This parameter must always start with
     * /, which by itself matches all requests to the virtual service name. You
     * can also match for path-based routing of requests. For example, if your virtual service
     * name is my-service.local and you want the route to match requests to
     * my-service.local/metrics, your prefix should be
     * /metrics.
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * The client request query parameters to match on.
     */
    val queryParameters: List<HttpQueryParameter>? = builder.queryParameters
    /**
     * The client request scheme to match on. Specify only one. Applicable only for HTTP2
     * routes.
     */
    val scheme: aws.sdk.kotlin.services.appmesh.model.HttpScheme? = builder.scheme

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.HttpRouteMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpRouteMatch(")
        append("headers=$headers,")
        append("method=$method,")
        append("path=$path,")
        append("prefix=$prefix,")
        append("queryParameters=$queryParameters,")
        append("scheme=$scheme)")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers?.hashCode() ?: 0
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpRouteMatch

        if (headers != other.headers) return false
        if (method != other.method) return false
        if (path != other.path) return false
        if (prefix != other.prefix) return false
        if (queryParameters != other.queryParameters) return false
        if (scheme != other.scheme) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.HttpRouteMatch = Builder(this).apply(block).build()

    class Builder {
        /**
         * The client request headers to match on.
         */
        var headers: List<HttpRouteHeader>? = null
        /**
         * The client request method to match on. Specify only one.
         */
        var method: aws.sdk.kotlin.services.appmesh.model.HttpMethod? = null
        /**
         * The client request path to match on.
         */
        var path: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch? = null
        /**
         * Specifies the path to match requests with. This parameter must always start with
         * /, which by itself matches all requests to the virtual service name. You
         * can also match for path-based routing of requests. For example, if your virtual service
         * name is my-service.local and you want the route to match requests to
         * my-service.local/metrics, your prefix should be
         * /metrics.
         */
        var prefix: kotlin.String? = null
        /**
         * The client request query parameters to match on.
         */
        var queryParameters: List<HttpQueryParameter>? = null
        /**
         * The client request scheme to match on. Specify only one. Applicable only for HTTP2
         * routes.
         */
        var scheme: aws.sdk.kotlin.services.appmesh.model.HttpScheme? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.HttpRouteMatch) : this() {
            this.headers = x.headers
            this.method = x.method
            this.path = x.path
            this.prefix = x.prefix
            this.queryParameters = x.queryParameters
            this.scheme = x.scheme
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.HttpRouteMatch = HttpRouteMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpPathMatch] inside the given [block]
         */
        fun path(block: aws.sdk.kotlin.services.appmesh.model.HttpPathMatch.Builder.() -> kotlin.Unit) {
            this.path = aws.sdk.kotlin.services.appmesh.model.HttpPathMatch.invoke(block)
        }
    }
}
