// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the health check policy for a virtual node's listener.
 */
class HealthCheckPolicy private constructor(builder: Builder) {
    /**
     * The number of consecutive successful health checks that must occur before declaring
     * listener healthy.
     */
    val healthyThreshold: kotlin.Int = builder.healthyThreshold
    /**
     * The time period in milliseconds between each health check execution.
     */
    val intervalMillis: kotlin.Long? = builder.intervalMillis
    /**
     * The destination path for the health check request. This value is only used if the
     * specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
     */
    val path: kotlin.String? = builder.path
    /**
     * The destination port for the health check request. This port must match the port defined
     * in the PortMapping for the listener.
     */
    val port: kotlin.Int = builder.port
    /**
     * The protocol for the health check request. If you specify grpc, then your
     * service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
     * Checking Protocol.
     */
    val protocol: aws.sdk.kotlin.services.appmesh.model.PortProtocol? = builder.protocol
    /**
     * The amount of time to wait when receiving a response from the health check, in
     * milliseconds.
     */
    val timeoutMillis: kotlin.Long? = builder.timeoutMillis
    /**
     * The number of consecutive failed health checks that must occur before declaring a
     * virtual node unhealthy.
     */
    val unhealthyThreshold: kotlin.Int = builder.unhealthyThreshold

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.HealthCheckPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheckPolicy(")
        append("healthyThreshold=$healthyThreshold,")
        append("intervalMillis=$intervalMillis,")
        append("path=$path,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("timeoutMillis=$timeoutMillis,")
        append("unhealthyThreshold=$unhealthyThreshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold
        result = 31 * result + (intervalMillis?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (timeoutMillis?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThreshold)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheckPolicy

        if (healthyThreshold != other.healthyThreshold) return false
        if (intervalMillis != other.intervalMillis) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (timeoutMillis != other.timeoutMillis) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.HealthCheckPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of consecutive successful health checks that must occur before declaring
         * listener healthy.
         */
        var healthyThreshold: kotlin.Int = 0
        /**
         * The time period in milliseconds between each health check execution.
         */
        var intervalMillis: kotlin.Long? = null
        /**
         * The destination path for the health check request. This value is only used if the
         * specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         */
        var path: kotlin.String? = null
        /**
         * The destination port for the health check request. This port must match the port defined
         * in the PortMapping for the listener.
         */
        var port: kotlin.Int = 0
        /**
         * The protocol for the health check request. If you specify grpc, then your
         * service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
         * Checking Protocol.
         */
        var protocol: aws.sdk.kotlin.services.appmesh.model.PortProtocol? = null
        /**
         * The amount of time to wait when receiving a response from the health check, in
         * milliseconds.
         */
        var timeoutMillis: kotlin.Long? = null
        /**
         * The number of consecutive failed health checks that must occur before declaring a
         * virtual node unhealthy.
         */
        var unhealthyThreshold: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.HealthCheckPolicy) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.intervalMillis = x.intervalMillis
            this.path = x.path
            this.port = x.port
            this.protocol = x.protocol
            this.timeoutMillis = x.timeoutMillis
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.HealthCheckPolicy = HealthCheckPolicy(this)
    }
}
